/*
 * Decompiled with CFR 0.152.
 */
package liquibase.diff;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.UnsupportedDatabaseSnapshot;
import liquibase.database.structure.View;
import liquibase.diff.DiffComparison;
import liquibase.diff.DiffResult;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.util.StringUtils;

public class Diff {
    private Database baseDatabase;
    private Database targetDatabase;
    private DatabaseSnapshot baseSnapshot;
    private DatabaseSnapshot targetSnapshot;
    private Set<DiffStatusListener> statusListeners = new HashSet<DiffStatusListener>();
    private boolean diffTables = true;
    private boolean diffColumns = true;
    private boolean diffViews = true;
    private boolean diffPrimaryKeys = true;
    private boolean diffUniqueConstraints = true;
    private boolean diffIndexes = true;
    private boolean diffForeignKeys = true;
    private boolean diffSequences = true;
    private boolean diffData = false;

    public Diff(Database baseDatabase, Database targetDatabase) {
        this.baseDatabase = baseDatabase;
        this.targetDatabase = targetDatabase;
    }

    public Diff(Database originalDatabase, String schema) throws JDBCException {
        this.targetDatabase = null;
        this.baseDatabase = originalDatabase;
        this.baseDatabase.setDefaultSchemaName(schema);
    }

    public Diff(DatabaseSnapshot baseDatabaseSnapshot, DatabaseSnapshot targetDatabaseSnapshot) {
        this.baseSnapshot = baseDatabaseSnapshot;
        this.targetSnapshot = targetDatabaseSnapshot;
    }

    public void addStatusListener(DiffStatusListener listener) {
        this.statusListeners.add(listener);
    }

    public void removeStatusListener(DiffStatusListener listener) {
        this.statusListeners.remove(listener);
    }

    public DiffResult compare() throws JDBCException {
        if (this.baseSnapshot == null) {
            this.baseSnapshot = this.baseDatabase.createDatabaseSnapshot(null, this.statusListeners);
        }
        if (this.targetSnapshot == null) {
            this.targetSnapshot = this.targetDatabase == null ? new UnsupportedDatabaseSnapshot() : this.targetDatabase.createDatabaseSnapshot(null, this.statusListeners);
        }
        DiffResult diffResult = new DiffResult(this.baseSnapshot, this.targetSnapshot);
        this.checkVersionInfo(diffResult);
        if (this.shouldDiffTables()) {
            this.checkTables(diffResult);
        }
        if (this.shouldDiffViews()) {
            this.checkViews(diffResult);
        }
        if (this.shouldDiffColumns()) {
            this.checkColumns(diffResult);
        }
        if (this.shouldDiffForeignKeys()) {
            this.checkForeignKeys(diffResult);
        }
        if (this.shouldDiffPrimaryKeys()) {
            this.checkPrimaryKeys(diffResult);
        }
        if (this.shouldDiffUniqueConstraints()) {
            this.checkUniqueConstraints(diffResult);
        }
        if (this.shouldDiffIndexes()) {
            this.checkIndexes(diffResult);
        }
        if (this.shouldDiffSequences()) {
            this.checkSequences(diffResult);
        }
        diffResult.setDiffData(this.shouldDiffData());
        return diffResult;
    }

    public void setDiffTypes(String diffTypes) {
        if (StringUtils.trimToNull(diffTypes) != null) {
            HashSet<String> types = new HashSet<String>(Arrays.asList(diffTypes.toLowerCase().split("\\s*,\\s*")));
            this.diffTables = types.contains("tables");
            this.diffColumns = types.contains("columns");
            this.diffViews = types.contains("views");
            this.diffPrimaryKeys = types.contains("primaryKeys");
            this.diffUniqueConstraints = types.contains("uniqueConstraints");
            this.diffIndexes = types.contains("indexes");
            this.diffForeignKeys = types.contains("foreignKeys");
            this.diffSequences = types.contains("sequences");
            this.diffData = types.contains("data");
        }
    }

    public boolean shouldDiffTables() {
        return this.diffTables;
    }

    public void setDiffTables(boolean diffTables) {
        this.diffTables = diffTables;
    }

    public boolean shouldDiffColumns() {
        return this.diffColumns;
    }

    public void setDiffColumns(boolean diffColumns) {
        this.diffColumns = diffColumns;
    }

    public boolean shouldDiffViews() {
        return this.diffViews;
    }

    public void setDiffViews(boolean diffViews) {
        this.diffViews = diffViews;
    }

    public boolean shouldDiffPrimaryKeys() {
        return this.diffPrimaryKeys;
    }

    public void setDiffPrimaryKeys(boolean diffPrimaryKeys) {
        this.diffPrimaryKeys = diffPrimaryKeys;
    }

    public boolean shouldDiffIndexes() {
        return this.diffIndexes;
    }

    public void setDiffIndexes(boolean diffIndexes) {
        this.diffIndexes = diffIndexes;
    }

    public boolean shouldDiffForeignKeys() {
        return this.diffForeignKeys;
    }

    public void setDiffForeignKeys(boolean diffForeignKeys) {
        this.diffForeignKeys = diffForeignKeys;
    }

    public boolean shouldDiffSequences() {
        return this.diffSequences;
    }

    public void setDiffSequences(boolean diffSequences) {
        this.diffSequences = diffSequences;
    }

    public boolean shouldDiffData() {
        return this.diffData;
    }

    public void setDiffData(boolean diffData) {
        this.diffData = diffData;
    }

    public boolean shouldDiffUniqueConstraints() {
        return this.diffUniqueConstraints;
    }

    public void setDiffUniqueConstraints(boolean diffUniqueConstraints) {
        this.diffUniqueConstraints = diffUniqueConstraints;
    }

    private void checkVersionInfo(DiffResult diffResult) throws JDBCException {
        if (this.targetDatabase != null) {
            diffResult.setProductName(new DiffComparison(this.baseDatabase.getDatabaseProductName(), this.targetDatabase.getDatabaseProductName()));
            diffResult.setProductVersion(new DiffComparison(this.baseDatabase.getDatabaseProductVersion(), this.targetDatabase.getDatabaseProductVersion()));
        }
    }

    private void checkTables(DiffResult diffResult) {
        Iterator<Table> i$ = this.baseSnapshot.getTables().iterator();
        while (i$.hasNext()) {
            Table baseTable = i$.next();
            if (this.targetSnapshot.getTables().contains(baseTable)) continue;
            diffResult.addMissingTable(baseTable);
        }
        i$ = this.targetSnapshot.getTables().iterator();
        while (i$.hasNext()) {
            Table targetTable = i$.next();
            if (this.baseSnapshot.getTables().contains(targetTable)) continue;
            diffResult.addUnexpectedTable(targetTable);
        }
    }

    private void checkViews(DiffResult diffResult) {
        Iterator<View> i$ = this.baseSnapshot.getViews().iterator();
        while (i$.hasNext()) {
            View baseView = i$.next();
            if (this.targetSnapshot.getViews().contains(baseView)) continue;
            diffResult.addMissingView(baseView);
        }
        i$ = this.targetSnapshot.getViews().iterator();
        while (i$.hasNext()) {
            View targetView = i$.next();
            if (this.baseSnapshot.getViews().contains(targetView)) continue;
            diffResult.addUnexpectedView(targetView);
        }
    }

    private void checkColumns(DiffResult diffResult) {
        Iterator<Column> i$ = this.baseSnapshot.getColumns().iterator();
        while (i$.hasNext()) {
            Column baseColumn = i$.next();
            if (this.targetSnapshot.getColumns().contains(baseColumn) || baseColumn.getTable() != null && diffResult.getMissingTables().contains(baseColumn.getTable()) || baseColumn.getView() != null && diffResult.getMissingViews().contains(baseColumn.getView())) continue;
            diffResult.addMissingColumn(baseColumn);
        }
        i$ = this.targetSnapshot.getColumns().iterator();
        while (i$.hasNext()) {
            Column baseColumn;
            Column targetColumn = i$.next();
            if (!(this.baseSnapshot.getColumns().contains(targetColumn) || targetColumn.getTable() != null && diffResult.getUnexpectedTables().contains(targetColumn.getTable()) || targetColumn.getView() != null && diffResult.getUnexpectedViews().contains(targetColumn.getView()))) {
                diffResult.addUnexpectedColumn(targetColumn);
                continue;
            }
            if (targetColumn.getTable() == null || diffResult.getUnexpectedTables().contains(targetColumn.getTable()) || (baseColumn = this.baseSnapshot.getColumn(targetColumn.getTable().getName(), targetColumn.getName())) != null && !targetColumn.isDifferent(baseColumn)) continue;
            diffResult.addChangedColumn(targetColumn);
        }
    }

    private void checkForeignKeys(DiffResult diffResult) {
        Iterator<ForeignKey> i$ = this.baseSnapshot.getForeignKeys().iterator();
        while (i$.hasNext()) {
            ForeignKey baseFK = i$.next();
            if (this.targetSnapshot.getForeignKeys().contains(baseFK)) continue;
            diffResult.addMissingForeignKey(baseFK);
        }
        i$ = this.targetSnapshot.getForeignKeys().iterator();
        while (i$.hasNext()) {
            ForeignKey targetFK = i$.next();
            if (this.baseSnapshot.getForeignKeys().contains(targetFK)) continue;
            diffResult.addUnexpectedForeignKey(targetFK);
        }
    }

    private void checkUniqueConstraints(DiffResult diffResult) {
        Iterator<UniqueConstraint> i$ = this.baseSnapshot.getUniqueConstraints().iterator();
        while (i$.hasNext()) {
            UniqueConstraint baseIndex = i$.next();
            if (this.targetSnapshot.getUniqueConstraints().contains(baseIndex)) continue;
            diffResult.addMissingUniqueConstraint(baseIndex);
        }
        i$ = this.targetSnapshot.getUniqueConstraints().iterator();
        while (i$.hasNext()) {
            UniqueConstraint targetIndex = i$.next();
            if (this.baseSnapshot.getUniqueConstraints().contains(targetIndex)) continue;
            diffResult.addUnexpectedUniqueConstraint(targetIndex);
        }
    }

    private void checkIndexes(DiffResult diffResult) {
        Iterator<Index> i$ = this.baseSnapshot.getIndexes().iterator();
        while (i$.hasNext()) {
            Index baseIndex = i$.next();
            if (this.targetSnapshot.getIndexes().contains(baseIndex)) continue;
            diffResult.addMissingIndex(baseIndex);
        }
        i$ = this.targetSnapshot.getIndexes().iterator();
        while (i$.hasNext()) {
            Index targetIndex = i$.next();
            if (this.baseSnapshot.getIndexes().contains(targetIndex)) continue;
            diffResult.addUnexpectedIndex(targetIndex);
        }
    }

    private void checkPrimaryKeys(DiffResult diffResult) {
        Iterator<PrimaryKey> i$ = this.baseSnapshot.getPrimaryKeys().iterator();
        while (i$.hasNext()) {
            PrimaryKey basePrimaryKey = i$.next();
            if (this.targetSnapshot.getPrimaryKeys().contains(basePrimaryKey)) continue;
            diffResult.addMissingPrimaryKey(basePrimaryKey);
        }
        i$ = this.targetSnapshot.getPrimaryKeys().iterator();
        while (i$.hasNext()) {
            PrimaryKey targetPrimaryKey = i$.next();
            if (this.baseSnapshot.getPrimaryKeys().contains(targetPrimaryKey)) continue;
            diffResult.addUnexpectedPrimaryKey(targetPrimaryKey);
        }
    }

    private void checkSequences(DiffResult diffResult) {
        Iterator<Sequence> i$ = this.baseSnapshot.getSequences().iterator();
        while (i$.hasNext()) {
            Sequence baseSequence = i$.next();
            if (this.targetSnapshot.getSequences().contains(baseSequence)) continue;
            diffResult.addMissingSequence(baseSequence);
        }
        i$ = this.targetSnapshot.getSequences().iterator();
        while (i$.hasNext()) {
            Sequence targetSequence = i$.next();
            if (this.baseSnapshot.getSequences().contains(targetSequence)) continue;
            diffResult.addUnexpectedSequence(targetSequence);
        }
    }
}

