/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import liquibase.DatabaseChangeLog;
import liquibase.FileOpener;
import liquibase.exception.ChangeLogParseException;
import liquibase.log.LogFactory;
import liquibase.parser.LiquibaseSchemaResolver;
import liquibase.parser.xml.XMLChangeLogHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLChangeLogParser {
    public static String getSchemaVersion() {
        return "1.9";
    }

    public DatabaseChangeLog parse(String physicalChangeLogLocation, FileOpener fileOpener, Map<String, Object> changeLogProperties) throws ChangeLogParseException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        if (System.getProperty("java.vm.version").startsWith("1.4")) {
            saxParserFactory.setValidating(false);
            saxParserFactory.setNamespaceAware(false);
        } else {
            saxParserFactory.setValidating(true);
            saxParserFactory.setNamespaceAware(true);
        }
        InputStream inputStream = null;
        try {
            SAXParser parser = saxParserFactory.newSAXParser();
            try {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            }
            catch (SAXNotRecognizedException e) {
            }
            catch (SAXNotSupportedException e) {
                // empty catch block
            }
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setEntityResolver(new LiquibaseSchemaResolver());
            xmlReader.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().warning(exception.getMessage());
                    throw exception;
                }

                public void error(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                    LogFactory.getLogger().severe(exception.getMessage());
                    throw exception;
                }
            });
            inputStream = fileOpener.getResourceAsStream(physicalChangeLogLocation);
            if (inputStream == null) {
                throw new ChangeLogParseException(new StringBuffer().append(physicalChangeLogLocation).append(" does not exist").toString());
            }
            XMLChangeLogHandler contentHandler = new XMLChangeLogHandler(physicalChangeLogLocation, fileOpener, changeLogProperties);
            xmlReader.setContentHandler(contentHandler);
            xmlReader.parse(new InputSource(inputStream));
            DatabaseChangeLog databaseChangeLog = contentHandler.getDatabaseChangeLog();
            return databaseChangeLog;
        }
        catch (ChangeLogParseException e) {
            throw e;
        }
        catch (IOException e) {
            throw new ChangeLogParseException(new StringBuffer().append("Error Reading Migration File: ").append(e.getMessage()).toString(), e);
        }
        catch (SAXParseException e) {
            throw new ChangeLogParseException(new StringBuffer().append("Error parsing line ").append(e.getLineNumber()).append(" column ").append(e.getColumnNumber()).append(" of ").append(physicalChangeLogLocation).append(": ").append(e.getMessage()).toString(), e);
        }
        catch (SAXException e) {
            for (Throwable parentCause = e.getException(); parentCause != null; parentCause = parentCause.getCause()) {
                if (!(parentCause instanceof ChangeLogParseException)) continue;
                throw (ChangeLogParseException)parentCause;
            }
            String reason = e.getMessage();
            String causeReason = null;
            if (e.getCause() != null) {
                causeReason = e.getCause().getMessage();
            }
            if (reason == null) {
                reason = causeReason != null ? causeReason : "Unknown Reason";
            }
            throw new ChangeLogParseException(new StringBuffer().append("Invalid Migration File: ").append(reason).toString(), e);
        }
        catch (Exception e) {
            throw new ChangeLogParseException(e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

