/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.JDBCException;
import liquibase.retro.net.sf.retrotranslator.runtime.java.io._Writer;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTMLWriter {
    protected File outputDir;
    protected Database database;

    public HTMLWriter(File outputDir, Database database) {
        this.outputDir = outputDir;
        this.database = database;
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
    }

    protected abstract void writeCustomHTML(FileWriter var1, Object var2, List<Change> var3, Database var4) throws IOException;

    private FileWriter createFileWriter(Object object) throws IOException {
        return new FileWriter(new File(this.outputDir, new StringBuffer().append(object.toString().toLowerCase()).append(".html").toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeHTML(Object object, List<Change> ranChanges, List<Change> changesToRun, String changeLog) throws IOException, DatabaseHistoryException, JDBCException {
        FileWriter fileWriter = this.createFileWriter(object);
        try {
            fileWriter.append("<html>");
            this.writeHeader(object, fileWriter);
            fileWriter.append("<body BGCOLOR=\"white\" onload=\"windowTitle();\">");
            _Writer.append(_Writer.append(fileWriter.append("<H2>"), this.createTitle(object)), "</H2>\n");
            this.writeBody(fileWriter, object, ranChanges, changesToRun);
            this.writeFooter(fileWriter, changeLog);
            fileWriter.append("</body>");
            fileWriter.append("</html>");
        }
        finally {
            fileWriter.close();
        }
    }

    private void writeFooter(FileWriter fileWriter, String changeLog) throws IOException {
        fileWriter.append("<hr>Generated: ");
        fileWriter.append(DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        fileWriter.append("<BR>Against: ");
        fileWriter.append(this.database.toString());
        fileWriter.append("<BR>Change Log: ");
        fileWriter.append(changeLog);
        fileWriter.append("<BR><BR>Generated By: ");
        _Writer.append(_Writer.append(fileWriter.append("<a href='http://www.liquibase.org' target='_TOP'>LiquiBase "), LiquibaseUtil.getBuildVersion()), "</a>");
    }

    protected void writeBody(FileWriter fileWriter, Object object, List<Change> ranChanges, List<Change> changesToRun) throws IOException, DatabaseHistoryException, JDBCException {
        this.writeCustomHTML(fileWriter, object, ranChanges, this.database);
        this.writeChanges("Pending Changes", fileWriter, changesToRun);
        this.writeChanges("Past Changes", fileWriter, ranChanges);
    }

    protected void writeTable(String title, List<List<String>> cells, FileWriter fileWriter) throws IOException {
        fileWriter.append("<P>");
        int colspan = 0;
        colspan = cells.size() == 0 ? 0 : cells.get(0).size();
        _Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(fileWriter.append("<TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n"), "<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n"), "<TD COLSPAN="), String.valueOf(colspan)), "><FONT SIZE=\"+2\">\n"), "<B>"), title), "</B></FONT></TD>\n"), "</TR>\n");
        for (List<String> row : cells) {
            fileWriter.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
            for (String cell : row) {
                this.writeTD(fileWriter, cell);
            }
            fileWriter.append("</TR>\n");
        }
        fileWriter.append("</TABLE>\n");
    }

    private void writeTD(FileWriter fileWriter, String filePath) throws IOException {
        fileWriter.append("<TD VALIGN=\"top\">\n");
        fileWriter.append(filePath);
        fileWriter.append("</TD>\n");
    }

    private void writeHeader(Object object, FileWriter fileWriter) throws IOException {
        String title = this.createTitle(object);
        _Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(_Writer.append(fileWriter.append("<head>"), "<title>"), title), "</title>"), "<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"../../stylesheet.css\" TITLE=\"Style\">"), "<SCRIPT type=\"text/javascript\">"), "function windowTitle()"), "{"), "    parent.document.title=\""), title), "\";"), "}"), "</SCRIPT>"), "</head>");
    }

    protected abstract String createTitle(Object var1);

    protected void writeChanges(String title, FileWriter fileWriter, List<Change> changes) throws IOException, DatabaseHistoryException, JDBCException {
        fileWriter.append("<p><TABLE BORDER=\"1\" WIDTH=\"100%\" CELLPADDING=\"3\" CELLSPACING=\"0\" SUMMARY=\"\">\n");
        fileWriter.append("<TR BGCOLOR=\"#CCCCFF\" CLASS=\"TableHeadingColor\">\n");
        fileWriter.append("<TD COLSPAN='4'><FONT SIZE=\"+2\">\n");
        fileWriter.append("<B>");
        fileWriter.append(title);
        fileWriter.append("</B></FONT></TD>\n");
        fileWriter.append("</TR>\n");
        ChangeSet lastChangeSet = null;
        if (changes == null || changes.size() == 0) {
            fileWriter.append("<tr><td>None Found</td></tr>");
        } else {
            for (Change change : changes) {
                if (!change.getChangeSet().equals(lastChangeSet)) {
                    lastChangeSet = change.getChangeSet();
                    fileWriter.append("<TR BGCOLOR=\"#EEEEFF\" CLASS=\"TableSubHeadingColor\">\n");
                    this.writeTD(fileWriter, new StringBuffer().append("<a href='../changelogs/").append(change.getChangeSet().getFilePath()).append(".xml'>").append(change.getChangeSet().getFilePath()).append("</a>").toString());
                    this.writeTD(fileWriter, change.getChangeSet().getId());
                    this.writeTD(fileWriter, new StringBuffer().append("<a href='../authors/").append(change.getChangeSet().getAuthor().toLowerCase()).append(".html'>").append(change.getChangeSet().getAuthor().toLowerCase()).append("</a>").toString());
                    ChangeSet.RunStatus runStatus = this.database.getRunStatus(change.getChangeSet());
                    if (runStatus.equals(ChangeSet.RunStatus.NOT_RAN)) {
                        String anchor = change.getChangeSet().toString(false).replaceAll("\\W", "_");
                        this.writeTD(fileWriter, new StringBuffer().append("NOT YET RAN [<a href='../pending/sql.html#").append(anchor).append("'>SQL</a>]").toString());
                    } else if (runStatus.equals(ChangeSet.RunStatus.INVALID_MD5SUM)) {
                        this.writeTD(fileWriter, "INVALID MD5SUM");
                    } else if (runStatus.equals(ChangeSet.RunStatus.ALREADY_RAN)) {
                        this.writeTD(fileWriter, new StringBuffer().append("Executed ").append(DateFormat.getDateTimeInstance(3, 3).format(this.database.getRanDate(change.getChangeSet()))).toString());
                    } else if (runStatus.equals(ChangeSet.RunStatus.RUN_AGAIN)) {
                        this.writeTD(fileWriter, "Executed, WILL RUN AGAIN");
                    } else {
                        throw new RuntimeException(new StringBuffer().append("Unknown run status: ").append(runStatus).toString());
                    }
                    fileWriter.append("</TR>");
                    if (StringUtils.trimToNull(change.getChangeSet().getComments()) != null) {
                        _Writer.append(_Writer.append(fileWriter.append("<TR><TD BGCOLOR='#EEEEFF' CLASS='TableSubHeadingColor' colspan='4'>"), change.getChangeSet().getComments()), "</TD></TR>");
                    }
                }
                fileWriter.append("<TR BGCOLOR=\"white\" CLASS=\"TableRowColor\">\n");
                _Writer.append(_Writer.append(fileWriter.append("<td colspan='4'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"), change.getConfirmationMessage()), "</td></TR>");
            }
        }
        fileWriter.append("</TABLE>");
        fileWriter.append("&nbsp;</P>");
    }
}

