/*
 * Decompiled with CFR 0.152.
 */
package liquibase.servlet;

import java.sql.Connection;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.naming.InitialContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import liquibase.ClassLoaderFileOpener;
import liquibase.CompositeFileOpener;
import liquibase.FileOpener;
import liquibase.FileSystemFileOpener;
import liquibase.Liquibase;
import liquibase.database.DatabaseFactory;
import liquibase.log.LogFactory;
import liquibase.servlet.LiquibaseStatusServlet;
import liquibase.util.NetUtil;

public class LiquibaseServletListener
implements ServletContextListener {
    private String changeLogFile;
    private String dataSource;
    private String contexts;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setContexts(String ctxt) {
        this.contexts = ctxt;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        block20: {
            String machine;
            int i$;
            int len$;
            String[] arr$;
            String hostName;
            LogFactory.getLogger().addHandler(new Handler(){

                public synchronized void publish(LogRecord record) {
                    LiquibaseStatusServlet.logMessage(record);
                }

                public void flush() {
                }

                public void close() throws SecurityException {
                }
            });
            try {
                hostName = NetUtil.getLocalHost().getHostName();
            }
            catch (Exception e) {
                servletContextEvent.getServletContext().log("Cannot find hostname: " + e.getMessage());
                return;
            }
            String shouldRunProperty = System.getProperty("liquibase.should.run");
            if (shouldRunProperty != null && !Boolean.valueOf(shouldRunProperty).booleanValue()) {
                LogFactory.getLogger().info("LiquiBase did not run on " + hostName + " because '" + "liquibase.should.run" + "' system property was set to false");
                return;
            }
            String machineIncludes = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_HOST_INCLUDES");
            String machineExcludes = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_HOST_EXCLUDES");
            String failOnError = servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_FAIL_ON_ERROR");
            boolean shouldRun = false;
            if (machineIncludes == null && machineExcludes == null) {
                shouldRun = true;
            } else if (machineIncludes != null) {
                arr$ = machineIncludes.split(",");
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    machine = arr$[i$];
                    if (!hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                    shouldRun = true;
                }
            } else if (machineExcludes != null) {
                shouldRun = true;
                arr$ = machineExcludes.split(",");
                len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    machine = arr$[i$];
                    if (!hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                    shouldRun = false;
                }
            }
            if (!shouldRun) {
                servletContextEvent.getServletContext().log("LiquibaseServletListener did not run due to LIQUIBASE_HOST_INCLUDES and/or LIQUIBASE_HOST_EXCLUDES");
                return;
            }
            this.setDataSource(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_DATA_SOURCE"));
            this.setChangeLogFile(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_CHANGELOG"));
            this.setContexts(servletContextEvent.getServletContext().getInitParameter("LIQUIBASE_CONTEXTS"));
            if (this.getChangeLogFile() == null) {
                throw new RuntimeException("Cannot run LiquiBase, LIQUIBASE_CHANGELOG is not set");
            }
            if (this.getDataSource() == null) {
                throw new RuntimeException("Cannot run LiquiBase, LIQUIBASE_DATA_SOURCE is not set");
            }
            try {
                InitialContext ic = null;
                Connection connection = null;
                try {
                    ic = new InitialContext();
                    DataSource dataSource = (DataSource)ic.lookup(this.dataSource);
                    connection = dataSource.getConnection();
                    ClassLoaderFileOpener clFO = new ClassLoaderFileOpener();
                    FileSystemFileOpener fsFO = new FileSystemFileOpener();
                    Liquibase liquibase = new Liquibase(this.getChangeLogFile(), (FileOpener)new CompositeFileOpener(new FileOpener[]{clFO, fsFO}), DatabaseFactory.getInstance().findCorrectDatabaseImplementation(connection));
                    liquibase.update(this.getContexts());
                }
                finally {
                    if (ic != null) {
                        ic.close();
                    }
                    if (connection != null) {
                        connection.close();
                    }
                }
            }
            catch (Exception e) {
                if ("false".equals(failOnError)) break block20;
                throw new RuntimeException(e);
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }
}

