/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import liquibase.ChangeSet;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.parser.filter.ChangeSetFilter;
import liquibase.parser.visitor.ChangeSetVisitor;

public class ChangeLogIterator {
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter[] changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public void run(ChangeSetVisitor visitor, Database database) throws LiquibaseException {
        List<ChangeSet> changeSetList = this.databaseChangeLog.getChangeSets();
        if (visitor.getDirection().equals(ChangeSetVisitor.Direction.REVERSE)) {
            Collections.reverse(changeSetList);
        }
        Iterator<ChangeSet> i$ = changeSetList.iterator();
        while (i$.hasNext()) {
            ChangeSet changeSet = i$.next();
            boolean shouldVisit = true;
            if (this.changeSetFilters != null) {
                Iterator<ChangeSetFilter> i$2 = this.changeSetFilters.iterator();
                while (i$2.hasNext()) {
                    ChangeSetFilter filter = i$2.next();
                    if (filter.accepts(changeSet)) continue;
                    shouldVisit = false;
                    break;
                }
            }
            if (!shouldVisit) continue;
            visitor.visit(changeSet, database);
        }
    }
}

