/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyColumnStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String columnType;
    private Object defaultValue;
    private Set<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();

    public ModifyColumnStatement(String schemaName, String tableName, String columnName, String columnType, Object defaultValue, ColumnConstraint[] constraints) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
        this.columnType = columnType;
        this.defaultValue = defaultValue;
        if (constraints != null) {
            this.constraints.addAll(Arrays.asList(constraints));
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getColumnType() {
        return this.columnType;
    }

    public Set<ColumnConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (this.isPrimaryKey() && (database instanceof CacheDatabase || database instanceof H2Database || database instanceof DB2Database || database instanceof DerbyDatabase || database instanceof SQLiteDatabase)) {
            throw new StatementNotSupportedOnDatabaseException("Adding primary key columns is not supported", this, database);
        }
        String alterTable = new StringBuffer().append("ALTER TABLE ").append(database.escapeTableName(this.getSchemaName(), this.getTableName())).toString();
        alterTable = new StringBuffer().append(alterTable).append(" ").append(this.getModifyString(database)).append(" ").toString();
        alterTable = new StringBuffer().append(alterTable).append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName())).toString();
        alterTable = new StringBuffer().append(alterTable).append(this.getPreDataTypeString(database)).toString();
        alterTable = new StringBuffer().append(alterTable).append(database.getColumnType(this.getColumnType(), false)).toString();
        if (this.supportsExtraMetaData(database)) {
            if (!this.isNullable()) {
                alterTable = new StringBuffer().append(alterTable).append(" NOT NULL").toString();
            } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
                alterTable = new StringBuffer().append(alterTable).append(" NULL").toString();
            }
            alterTable = new StringBuffer().append(alterTable).append(this.getDefaultClause(database)).toString();
            if (this.isAutoIncrement()) {
                alterTable = new StringBuffer().append(alterTable).append(" ").append(database.getAutoIncrementClause()).toString();
            }
            if (this.isPrimaryKey()) {
                alterTable = new StringBuffer().append(alterTable).append(" PRIMARY KEY").toString();
            }
        }
        alterTable = new StringBuffer().append(alterTable).append(this.getPostDataTypeString(database)).toString();
        return alterTable;
    }

    private boolean supportsExtraMetaData(Database database) {
        return database instanceof MSSQLDatabase || database instanceof MySQLDatabase;
    }

    private String getModifyString(Database database) {
        if (database instanceof HsqlDatabase || database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof MSSQLDatabase || database instanceof CacheDatabase) {
            return "ALTER COLUMN";
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MySQLDatabase) {
            return "MODIFY";
        }
        if (database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return "MODIFY (";
        }
        return "ALTER COLUMN";
    }

    private String getPreDataTypeString(Database database) {
        if (database instanceof DerbyDatabase || database instanceof DB2Database) {
            return " SET DATA TYPE ";
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof HsqlDatabase || database instanceof CacheDatabase || database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return " ";
        }
        return " TYPE ";
    }

    private String getPostDataTypeString(Database database) {
        if (database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return " )";
        }
        return "";
    }

    public boolean isAutoIncrement() {
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof AutoIncrementConstraint)) continue;
            return true;
        }
        return false;
    }

    public boolean isPrimaryKey() {
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof PrimaryKeyConstraint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return true;
    }

    private String getDefaultClause(Database database) {
        String clause = "";
        if (this.getDefaultValue() != null && database instanceof MySQLDatabase) {
            clause = new StringBuffer().append(clause).append(" DEFAULT ").append(database.convertJavaObjectToString(this.getDefaultValue())).toString();
        }
        return clause;
    }

    public boolean isNullable() {
        if (this.isPrimaryKey()) {
            return false;
        }
        for (ColumnConstraint constraint : this.getConstraints()) {
            if (!(constraint instanceof NotNullConstraint)) continue;
            return false;
        }
        return true;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }
}

