/*
 * Decompiled with CFR 0.152.
 */
package liquibase.preconditions;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.preconditions.Precondition;

public class SqlPrecondition
implements Precondition {
    private String expectedResult;
    private String sql;

    public String getExpectedResult() {
        return this.expectedResult;
    }

    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void check(Database database, DatabaseChangeLog changeLog) throws PreconditionFailedException, PreconditionErrorException {
        Statement statement = null;
        ResultSet resultSet = null;
        DatabaseConnection connection = database.getConnection();
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.getSql());
            if (!resultSet.next()) {
                throw new PreconditionFailedException("No rows returned from SQL Precondition", changeLog, this);
            }
            String returnString = resultSet.getString(1);
            if (resultSet.next()) {
                throw new PreconditionFailedException("Too Many rows returned from SQL Precondition", changeLog, this);
            }
            if (!this.expectedResult.equals(returnString)) {
                throw new PreconditionFailedException("SQL Precondition failed.  Expected '" + this.expectedResult + "' got '" + returnString + "'", changeLog, this);
            }
        }
        catch (SQLException e) {
            throw new PreconditionErrorException(e, changeLog, this);
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {}
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {}
        }
    }

    public String getTagName() {
        return "sqlCheck";
    }
}

