/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class TypedStringValue
implements BeanMetadataElement {
    private String value;
    private Object targetType;
    private Object source;

    public TypedStringValue(String value) {
        this.setValue(value);
    }

    public TypedStringValue(String value, Class targetType) {
        this.setValue(value);
        this.setTargetType(targetType);
    }

    public TypedStringValue(String value, String targetTypeName) {
        this.setValue(value);
        this.setTargetTypeName(targetTypeName);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setTargetType(Class targetType) {
        Assert.notNull((Object)targetType, (String)"'targetType' must not be null");
        this.targetType = targetType;
    }

    public Class getTargetType() {
        if (!(this.targetType instanceof Class)) {
            throw new IllegalStateException("Typed String value does not carry a resolved target type");
        }
        return (Class)this.targetType;
    }

    public void setTargetTypeName(String targetTypeName) {
        Assert.notNull((Object)targetTypeName, (String)"'targetTypeName' must not be null");
        this.targetType = targetTypeName;
    }

    public String getTargetTypeName() {
        if (this.targetType instanceof Class) {
            return ((Class)this.targetType).getName();
        }
        return (String)this.targetType;
    }

    public boolean hasTargetType() {
        return this.targetType instanceof Class;
    }

    public Class resolveTargetType(ClassLoader classLoader) throws ClassNotFoundException {
        if (this.targetType == null) {
            return null;
        }
        Class resolvedClass = ClassUtils.forName((String)this.getTargetTypeName(), (ClassLoader)classLoader);
        this.targetType = resolvedClass;
        return resolvedClass;
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TypedStringValue)) {
            return false;
        }
        TypedStringValue otherValue = (TypedStringValue)other;
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)otherValue.value) && ObjectUtils.nullSafeEquals((Object)this.targetType, (Object)otherValue.targetType);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.value) * 29 + ObjectUtils.nullSafeHashCode((Object)this.targetType);
    }

    public String toString() {
        return "TypedStringValue: value [" + this.value + "], target type [" + this.targetType + "]";
    }
}

