/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.AlterSequenceStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Sequence;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlterSequenceChange
extends AbstractChange {
    private String schemaName;
    private String sequenceName;
    private Integer incrementBy;
    private Integer maxValue;
    private Integer minValue;
    private Boolean ordered;

    public AlterSequenceChange() {
        super("alterSequence", "Alter Sequence");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getSequenceName() {
        return this.sequenceName;
    }

    public void setSequenceName(String sequenceName) {
        this.sequenceName = sequenceName;
    }

    public Integer getIncrementBy() {
        return this.incrementBy;
    }

    public void setIncrementBy(Integer incrementBy) {
        this.incrementBy = incrementBy;
    }

    public Integer getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Integer maxValue) {
        this.maxValue = maxValue;
    }

    public Integer getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Integer minValue) {
        this.minValue = minValue;
    }

    public Boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(Boolean ordered) {
        this.ordered = ordered;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.sequenceName) == null) {
            throw new InvalidChangeDefinitionException("sequenceName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (!database.supportsSequences()) {
            throw new UnsupportedChangeException(new StringBuffer().append("Sequences do not exist in ").append(database.getProductName()).toString());
        }
        return new SqlStatement[]{new AlterSequenceStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getSequenceName()).setIncrementBy(this.getIncrementBy()).setMaxValue(this.getMaxValue()).setMinValue(this.getMinValue()).setOrdered(this.isOrdered())};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Sequence ").append(this.getSequenceName()).append(" altered").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement("alterSequence");
        node.setAttribute("sequenceName", this.getSequenceName());
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        if (this.getMinValue() != null) {
            node.setAttribute("minValue", this.getMinValue().toString());
        }
        if (this.getMaxValue() != null) {
            node.setAttribute("maxValue", this.getMaxValue().toString());
        }
        if (this.getIncrementBy() != null) {
            node.setAttribute("incrementBy", this.getIncrementBy().toString());
        }
        if (this.isOrdered() != null) {
            node.setAttribute("ordered", this.isOrdered().toString());
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Sequence dbObject = new Sequence();
        dbObject.setName(this.sequenceName);
        return new HashSet<DatabaseObject>(Arrays.asList(dbObject));
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

