/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import liquibase.change.ConstraintsConfig;
import liquibase.database.Database;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.structure.Column;
import liquibase.util.ISODateFormat;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ColumnConfig {
    private String name;
    private String type;
    private String value;
    private Number valueNumeric;
    private Date valueDate;
    private Boolean valueBoolean;
    private String defaultValue;
    private Number defaultValueNumeric;
    private Date defaultValueDate;
    private Boolean defaultValueBoolean;
    private ConstraintsConfig constraints;
    private Boolean autoIncrement;
    private String remarks;

    public ColumnConfig(Column columnStructure) {
        this.setName(columnStructure.getName());
        this.setType(columnStructure.getTypeName());
        if (columnStructure.getDefaultValue() != null) {
            this.setDefaultValue(columnStructure.getDefaultValue().toString());
        }
        this.setAutoIncrement(columnStructure.isAutoIncrement());
        ConstraintsConfig constraints = new ConstraintsConfig();
        constraints.setNullable(columnStructure.isNullable());
        constraints.setPrimaryKey(columnStructure.isPrimaryKey());
        constraints.setUnique(columnStructure.isUnique());
        this.setConstraints(constraints);
    }

    public ColumnConfig(ColumnConfig column) {
        this.setName(column.getName());
        this.setType(column.getType());
        this.setDefaultValue(column.getDefaultValue());
        this.setAutoIncrement(column.isAutoIncrement());
        if (column.getConstraints() != null) {
            ConstraintsConfig constraints = new ConstraintsConfig();
            constraints.setNullable(column.getConstraints().isNullable());
            constraints.setPrimaryKey(column.getConstraints().isPrimaryKey());
            constraints.setUnique(column.getConstraints().isUnique());
        }
        this.setConstraints(this.constraints);
    }

    public ColumnConfig() {
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Number getValueNumeric() {
        return this.valueNumeric;
    }

    public void setValueNumeric(String valueNumeric) {
        if (valueNumeric == null || valueNumeric.equalsIgnoreCase("null")) {
            this.valueNumeric = null;
        } else {
            valueNumeric = valueNumeric.replaceFirst("^\\(", "");
            if ((valueNumeric = valueNumeric.replaceFirst("\\)$", "")).matches("\\d+\\.?\\d*")) {
                try {
                    this.valueNumeric = NumberFormat.getInstance(Locale.US).parse(valueNumeric);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            } else {
                this.valueNumeric = new ComputedNumericValue(valueNumeric);
            }
        }
    }

    public void setValueNumeric(Number valueNumeric) {
        this.valueNumeric = valueNumeric;
    }

    public Boolean getValueBoolean() {
        return this.valueBoolean;
    }

    public void setValueBoolean(Boolean valueBoolean) {
        this.valueBoolean = valueBoolean;
    }

    public Date getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(Date valueDate) {
        this.valueDate = valueDate;
    }

    public void setValueDate(String valueDate) {
        if (valueDate == null || valueDate.equalsIgnoreCase("null")) {
            this.valueDate = null;
        }
        try {
            this.valueDate = new ISODateFormat().parse(valueDate);
        }
        catch (ParseException e) {
            this.valueDate = new ComputedDateValue(valueDate);
        }
    }

    public Object getValueObject() {
        if (this.getValue() != null) {
            return this.getValue();
        }
        if (this.getValueBoolean() != null) {
            return this.getValueBoolean();
        }
        if (this.getValueNumeric() != null) {
            return this.getValueNumeric();
        }
        if (this.getValueDate() != null) {
            return this.getValueDate();
        }
        return null;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Number getDefaultValueNumeric() {
        return this.defaultValueNumeric;
    }

    public void setDefaultValueNumeric(Number defaultValueNumeric) {
        this.defaultValueNumeric = defaultValueNumeric;
    }

    public void setDefaultValueNumeric(String defaultValueNumeric) throws ParseException {
        if (defaultValueNumeric == null || defaultValueNumeric.equalsIgnoreCase("null")) {
            this.defaultValueNumeric = null;
        } else if ("GENERATED_BY_DEFAULT".equals(defaultValueNumeric)) {
            this.setAutoIncrement(true);
        } else {
            defaultValueNumeric = defaultValueNumeric.replaceFirst("^\\(", "");
            defaultValueNumeric = defaultValueNumeric.replaceFirst("\\)$", "");
            this.defaultValueNumeric = NumberFormat.getInstance(Locale.US).parse(defaultValueNumeric);
        }
    }

    public Date getDefaultValueDate() {
        return this.defaultValueDate;
    }

    public void setDefaultValueDate(String defaultValueDate) {
        if (defaultValueDate == null || defaultValueDate.equalsIgnoreCase("null")) {
            this.defaultValueDate = null;
        }
        try {
            this.defaultValueDate = new ISODateFormat().parse(defaultValueDate);
        }
        catch (ParseException e) {
            this.defaultValueDate = new ComputedDateValue(defaultValueDate);
        }
    }

    public void setDefaultValueDate(Date defaultValueDate) {
        this.defaultValueDate = defaultValueDate;
    }

    public Boolean getDefaultValueBoolean() {
        return this.defaultValueBoolean;
    }

    public void setDefaultValueBoolean(Boolean defaultValueBoolean) {
        this.defaultValueBoolean = defaultValueBoolean;
    }

    public Object getDefaultValueObject() {
        if (this.getDefaultValue() != null) {
            return this.getDefaultValue();
        }
        if (this.getDefaultValueBoolean() != null) {
            return this.getDefaultValueBoolean();
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric();
        }
        if (this.getDefaultValueDate() != null) {
            return this.getDefaultValueDate();
        }
        return null;
    }

    public ConstraintsConfig getConstraints() {
        return this.constraints;
    }

    public void setConstraints(ConstraintsConfig constraints) {
        this.constraints = constraints;
    }

    public Boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(Boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public Element createNode(Document document) {
        ConstraintsConfig constraints;
        Element element = document.createElement("column");
        if (this.getName() != null) {
            element.setAttribute("name", this.getName());
        }
        if (this.getType() != null) {
            element.setAttribute("type", this.getType());
        }
        if (this.getDefaultValue() != null) {
            element.setAttribute("defaultValue", this.getDefaultValue());
        }
        if (this.getDefaultValueNumeric() != null) {
            element.setAttribute("defaultValueNumeric", this.getDefaultValueNumeric().toString());
        }
        if (this.getDefaultValueDate() != null) {
            element.setAttribute("defaultValueDate", new ISODateFormat().format(this.getDefaultValueDate()));
        }
        if (this.getDefaultValueBoolean() != null) {
            element.setAttribute("defaultValueBoolean", this.getDefaultValueBoolean().toString());
        }
        if (this.getValue() != null) {
            element.setAttribute("value", this.getValue());
        }
        if (this.getValueNumeric() != null) {
            element.setAttribute("valueNumeric", this.getValueNumeric().toString());
        }
        if (this.getValueBoolean() != null) {
            element.setAttribute("valueBoolean", this.getValueBoolean().toString());
        }
        if (this.getValueDate() != null) {
            element.setAttribute("valueDate", new ISODateFormat().format(this.getValueDate()));
        }
        if (StringUtils.trimToNull(this.getRemarks()) != null) {
            element.setAttribute("remarks", this.getRemarks());
        }
        if (this.isAutoIncrement() != null && this.isAutoIncrement().booleanValue()) {
            element.setAttribute("autoIncrement", "true");
        }
        if ((constraints = this.getConstraints()) != null) {
            Element constraintsElement = document.createElement("constraints");
            if (constraints.getCheck() != null) {
                constraintsElement.setAttribute("check", constraints.getCheck());
            }
            if (constraints.getForeignKeyName() != null) {
                constraintsElement.setAttribute("foreignKeyName", constraints.getForeignKeyName());
            }
            if (constraints.getReferences() != null) {
                constraintsElement.setAttribute("references", constraints.getReferences());
            }
            if (constraints.isDeferrable() != null) {
                constraintsElement.setAttribute("deferrable", constraints.isDeferrable().toString());
            }
            if (constraints.isDeleteCascade() != null) {
                constraintsElement.setAttribute("deleteCascade", constraints.isDeleteCascade().toString());
            }
            if (constraints.isInitiallyDeferred() != null) {
                constraintsElement.setAttribute("initiallyDeferred", constraints.isInitiallyDeferred().toString());
            }
            if (constraints.isNullable() != null) {
                constraintsElement.setAttribute("nullable", constraints.isNullable().toString());
            }
            if (constraints.isPrimaryKey() != null) {
                constraintsElement.setAttribute("primaryKey", constraints.isPrimaryKey().toString());
            }
            if (constraints.isUnique() != null) {
                constraintsElement.setAttribute("unique", constraints.isUnique().toString());
            }
            if (constraints.getUniqueConstraintName() != null) {
                constraintsElement.setAttribute("uniqueConstraintName", constraints.getUniqueConstraintName());
            }
            if (constraints.getPrimaryKeyName() != null) {
                constraintsElement.setAttribute("primaryKeyName", constraints.getPrimaryKeyName());
            }
            element.appendChild(constraintsElement);
        }
        return element;
    }

    public String getDefaultColumnValue(Database database) {
        if (this.getDefaultValue() != null) {
            if ("null".equalsIgnoreCase(this.getDefaultValue())) {
                return "NULL";
            }
            if (!database.shouldQuoteValue(this.getDefaultValue())) {
                return this.getDefaultValue();
            }
            return "'" + this.getDefaultValue().replaceAll("'", "''") + "'";
        }
        if (this.getDefaultValueNumeric() != null) {
            return this.getDefaultValueNumeric().toString();
        }
        if (this.getDefaultValueBoolean() != null) {
            String returnValue = this.getDefaultValueBoolean() != false ? database.getTrueBooleanValue() : database.getFalseBooleanValue();
            if (returnValue.matches("\\d+")) {
                return returnValue;
            }
            return "'" + returnValue + "'";
        }
        if (this.getDefaultValueDate() != null) {
            Date defaultDateValue = this.getDefaultValueDate();
            return database.getDateLiteral(defaultDateValue);
        }
        return "NULL";
    }

    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null || this.getDefaultValueBoolean() != null || this.getDefaultValueDate() != null || this.getDefaultValueNumeric() != null;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
}

