/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnChange;
import liquibase.change.ColumnConfig;
import liquibase.change.DropColumnChange;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeColumnChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String column1Name;
    private String joinString;
    private String column2Name;
    private String finalColumnName;
    private String finalColumnType;

    public MergeColumnChange() {
        super("mergeColumns", "Merge Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumn1Name() {
        return this.column1Name;
    }

    public void setColumn1Name(String column1Name) {
        this.column1Name = column1Name;
    }

    public String getJoinString() {
        return this.joinString;
    }

    public void setJoinString(String joinString) {
        this.joinString = joinString;
    }

    public String getColumn2Name() {
        return this.column2Name;
    }

    public void setColumn2Name(String column2Name) {
        this.column2Name = column2Name;
    }

    public String getFinalColumnName() {
        return this.finalColumnName;
    }

    public void setFinalColumnName(String finalColumnName) {
        this.finalColumnName = finalColumnName;
    }

    public String getFinalColumnType() {
        return this.finalColumnType;
    }

    public void setFinalColumnType(String finalColumnType) {
        this.finalColumnType = finalColumnType;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.column1Name) == null) {
            throw new InvalidChangeDefinitionException("column1Name is required", this);
        }
        if (StringUtils.trimToNull(this.column2Name) == null) {
            throw new InvalidChangeDefinitionException("column2Name is required", this);
        }
        if (StringUtils.trimToNull(this.finalColumnName) == null) {
            throw new InvalidChangeDefinitionException("finalColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.finalColumnType) == null) {
            throw new InvalidChangeDefinitionException("finalColumnType is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        AddColumnChange addNewColumnChange = new AddColumnChange();
        String schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        addNewColumnChange.setSchemaName(schemaName);
        addNewColumnChange.setTableName(this.getTableName());
        ColumnConfig columnConfig = new ColumnConfig();
        columnConfig.setName(this.getFinalColumnName());
        columnConfig.setType(this.getFinalColumnType());
        addNewColumnChange.addColumn(columnConfig);
        statements.addAll(Arrays.asList(addNewColumnChange.generateStatements(database)));
        String updateStatement = new StringBuffer().append("UPDATE ").append(database.escapeTableName(schemaName, this.getTableName())).append(" SET ").append(this.getFinalColumnName()).append(" = ").append(database.getConcatSql(new String[]{this.getColumn1Name(), new StringBuffer().append("'").append(this.getJoinString()).append("'").toString(), this.getColumn2Name()})).toString();
        statements.add(new RawSqlStatement(updateStatement));
        if (database instanceof SQLiteDatabase) {
            SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

                public ColumnConfig[] getColumnsToAdd() {
                    ColumnConfig[] new_columns = new ColumnConfig[1];
                    ColumnConfig new_column = new ColumnConfig();
                    new_column.setName(MergeColumnChange.this.getFinalColumnName());
                    new_column.setType(MergeColumnChange.this.getFinalColumnType());
                    new_columns[0] = new ColumnConfig(new_column);
                    return new_columns;
                }

                public boolean copyThisColumn(ColumnConfig column) {
                    return !column.getName().equals(MergeColumnChange.this.getColumn1Name()) && !column.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisColumn(ColumnConfig column) {
                    return !column.getName().equals(MergeColumnChange.this.getColumn1Name()) && !column.getName().equals(MergeColumnChange.this.getColumn2Name());
                }

                public boolean createThisIndex(Index index) {
                    return !index.getColumns().contains(MergeColumnChange.this.getColumn1Name()) && !index.getColumns().contains(MergeColumnChange.this.getColumn2Name());
                }
            };
            try {
                statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
            }
            catch (JDBCException e) {
                e.printStackTrace();
            }
        } else {
            DropColumnChange dropColumn1Change = new DropColumnChange();
            dropColumn1Change.setSchemaName(schemaName);
            dropColumn1Change.setTableName(this.getTableName());
            dropColumn1Change.setColumnName(this.getColumn1Name());
            statements.addAll(Arrays.asList(dropColumn1Change.generateStatements(database)));
            DropColumnChange dropColumn2Change = new DropColumnChange();
            dropColumn2Change.setSchemaName(schemaName);
            dropColumn2Change.setTableName(this.getTableName());
            dropColumn2Change.setColumnName(this.getColumn2Name());
            statements.addAll(Arrays.asList(dropColumn2Change.generateStatements(database)));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    public SqlStatement[] generateStatements(DerbyDatabase database) throws UnsupportedChangeException {
        throw new UnsupportedChangeException("Derby does not currently support merging columns");
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Columns ").append(this.getTableName()).append(".").append(this.getColumn1Name()).append(" and ").append(this.getTableName()).append(".").append(this.getColumn2Name()).append(" merged").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("column1Name", this.getColumn1Name());
        element.setAttribute("joinString", this.getJoinString());
        element.setAttribute("column2Name", this.getColumn2Name());
        element.setAttribute("finalColumnName", this.getFinalColumnName());
        element.setAttribute("finalColumnType", this.getFinalColumnType());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        returnSet.add(table);
        Column column1 = new Column();
        column1.setTable(table);
        column1.setName(this.column1Name);
        returnSet.add(column1);
        Column column2 = new Column();
        column2.setTable(table);
        column2.setName(this.column2Name);
        returnSet.add(column2);
        return returnSet;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

