/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import liquibase.FileOpener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemFileOpener
implements FileOpener {
    String baseDirectory;

    public FileSystemFileOpener() {
        this.baseDirectory = null;
    }

    public FileSystemFileOpener(String base) {
        if (new File(base).isFile()) {
            throw new IllegalArgumentException("base must be a directory");
        }
        this.baseDirectory = base;
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        File relativeFile;
        File absoluteFile = new File(file);
        File file2 = relativeFile = this.baseDirectory == null ? new File(file) : new File(this.baseDirectory, file);
        if (absoluteFile.exists() && absoluteFile.isFile() && absoluteFile.isAbsolute()) {
            return new FileInputStream(absoluteFile);
        }
        if (relativeFile.exists() && relativeFile.isFile()) {
            return new FileInputStream(relativeFile);
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        String directoryPath = new File(packageName).isAbsolute() || this.baseDirectory == null ? packageName : new StringBuffer().append(this.baseDirectory).append(File.separator).append(packageName).toString();
        File directoryFile = new File(directoryPath);
        if (!directoryFile.exists()) {
            return new Vector().elements();
        }
        File[] files = directoryFile.listFiles();
        ArrayList<URL> results = new ArrayList<URL>();
        for (File f : files) {
            results.add(new URL(new StringBuffer().append("file://").append(f.getCanonicalPath()).toString()));
        }
        final Iterator it = results.iterator();
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return it.hasNext();
            }

            @Override
            public URL nextElement() {
                return (URL)it.next();
            }

            @Override
            public /* synthetic */ Object nextElement() {
                return this.nextElement();
            }
        };
    }

    @Override
    public ClassLoader toClassLoader() {
        try {
            return new URLClassLoader(new URL[]{new URL(new StringBuffer().append("file://").append(this.baseDirectory).toString())});
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

