/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import liquibase.ChangeSet;
import liquibase.RanChangeSet;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropSequenceChange;
import liquibase.change.DropTableChange;
import liquibase.change.DropViewChange;
import liquibase.change.RawSQLChange;
import liquibase.database.DataType;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.SQLConnectionDelegate;
import liquibase.database.sql.AddColumnStatement;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.ComputedDateValue;
import liquibase.database.sql.ComputedNumericValue;
import liquibase.database.sql.CreateTableStatement;
import liquibase.database.sql.InsertStatement;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.TagDatabaseStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.database.template.JdbcOutputTemplate;
import liquibase.database.template.JdbcTemplate;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.DatabaseHistoryException;
import liquibase.exception.DateParseException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.lock.LockHandler;
import liquibase.log.LogFactory;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Integer;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._String;
import liquibase.util.ISODateFormat;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatabase
implements Database {
    private DatabaseConnection connection;
    private String defaultSchemaName;
    protected static final Logger log = LogFactory.getLogger();
    protected String currentDateTimeFunction;
    private JdbcTemplate jdbcTemplate = new JdbcTemplate(this);
    private List<RanChangeSet> ranChangeSetList;
    private static final DataType DATE_TYPE = new DataType("DATE", false);
    private static final DataType TIME_TYPE = new DataType("TIME", false);
    private static final DataType BIGINT_TYPE = new DataType("BIGINT", true);
    private static final DataType CHAR_TYPE = new DataType("CHAR", true);
    private static final DataType VARCHAR_TYPE = new DataType("VARCHAR", true);
    private static final DataType FLOAT_TYPE = new DataType("FLOAT", true);
    private static final DataType DOUBLE_TYPE = new DataType("DOUBLE", true);
    private static final DataType INT_TYPE = new DataType("INT", true);
    private static final DataType TINYINT_TYPE = new DataType("TINYINT", true);
    private static Pattern CREATE_VIEW_AS_PATTERN = Pattern.compile("^CREATE\\s+.*?VIEW\\s+.*?AS\\s+", 34);
    protected String databaseChangeLogTableName = "DatabaseChangeLog".toUpperCase();
    protected String shortDatabaseChangeLogTableName = "DbChgLog".toUpperCase();
    protected String databaseChangeLogLockTableName = "DatabaseChangeLogLock".toUpperCase();
    protected String shortDatabaseChangeLogLockTableName = "DbChgLogLock".toUpperCase();
    static /* synthetic */ Class class$java$lang$String;

    protected AbstractDatabase() {
    }

    @Override
    public DatabaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(Connection conn) {
        this.connection = new SQLConnectionDelegate(conn);
        try {
            this.connection.setAutoCommit(this.getAutoCommitMode());
        }
        catch (SQLException sqle) {
            log.warning(new StringBuffer().append("Can not set auto commit to ").append(this.getAutoCommitMode()).append(" on connection").toString());
        }
    }

    @Override
    public void setConnection(DatabaseConnection conn) {
        this.connection = conn;
        try {
            this.connection.setAutoCommit(this.getAutoCommitMode());
        }
        catch (SQLException sqle) {
            log.warning(new StringBuffer().append("Can not set auto commit to ").append(this.getAutoCommitMode()).append(" on connection").toString());
        }
    }

    @Override
    public boolean getAutoCommitMode() {
        return !this.supportsDDLInTransaction();
    }

    @Override
    public boolean supportsDDLInTransaction() {
        return true;
    }

    @Override
    public String getDatabaseProductName() {
        try {
            return this.connection.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get database name");
        }
    }

    @Override
    public String getDatabaseProductName(Connection conn) throws JDBCException {
        try {
            return conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getDatabaseProductVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseProductVersion();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public int getDatabaseMajorVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseMajorVersion();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public int getDatabaseMinorVersion() throws JDBCException {
        try {
            return this.connection.getMetaData().getDatabaseMinorVersion();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getDriverName() throws JDBCException {
        try {
            return this.connection.getMetaData().getDriverName();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getConnectionURL() throws JDBCException {
        try {
            return this.connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getConnectionUsername() throws JDBCException {
        try {
            return this.connection.getMetaData().getUserName();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public String getDefaultCatalogName() throws JDBCException {
        return null;
    }

    protected String getDefaultDatabaseSchemaName() throws JDBCException {
        return this.getConnectionUsername();
    }

    @Override
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    public void setDefaultSchemaName(String schemaName) throws JDBCException {
        this.defaultSchemaName = schemaName;
    }

    protected Set<String> getSystemTablesAndViews() {
        return new HashSet<String>();
    }

    @Override
    public boolean supportsSequences() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    @Override
    public void setCurrentDateTimeFunction(String function) {
        if (function != null) {
            this.currentDateTimeFunction = function;
        }
    }

    @Override
    public String getColumnType(String columnType, Boolean autoIncrement) {
        String dataTypeName = null;
        String precision = null;
        if (columnType.startsWith("java.sql.Types") && _String.contains(columnType, "(")) {
            precision = columnType.substring(columnType.indexOf("(") + 1, columnType.indexOf(")"));
            dataTypeName = columnType.substring(columnType.lastIndexOf(".") + 1, columnType.indexOf("("));
        } else if (columnType.startsWith("java.sql.Types")) {
            dataTypeName = columnType.substring(columnType.lastIndexOf(".") + 1);
        } else if (_String.contains(columnType, "(")) {
            precision = columnType.substring(columnType.indexOf("(") + 1, columnType.indexOf(")"));
            dataTypeName = columnType.substring(0, columnType.indexOf("("));
        } else {
            dataTypeName = columnType;
        }
        DataType returnTypeName = null;
        if (dataTypeName.equalsIgnoreCase("BIGINT")) {
            returnTypeName = this.getBigIntType();
        } else if (dataTypeName.equalsIgnoreCase("BLOB")) {
            returnTypeName = this.getBlobType();
        } else if (dataTypeName.equalsIgnoreCase("BOOLEAN")) {
            returnTypeName = this.getBooleanType();
        } else if (dataTypeName.equalsIgnoreCase("CHAR")) {
            returnTypeName = this.getCharType();
        } else if (dataTypeName.equalsIgnoreCase("CLOB")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("CURRENCY")) {
            returnTypeName = this.getCurrencyType();
        } else if (dataTypeName.equalsIgnoreCase("DATE")) {
            returnTypeName = this.getDateType();
        } else if (dataTypeName.equalsIgnoreCase("DATETIME")) {
            returnTypeName = this.getDateTimeType();
        } else if (dataTypeName.equalsIgnoreCase("DOUBLE")) {
            returnTypeName = this.getDoubleType();
        } else if (dataTypeName.equalsIgnoreCase("FLOAT")) {
            returnTypeName = this.getFloatType();
        } else if (dataTypeName.equalsIgnoreCase("INT")) {
            returnTypeName = this.getIntType();
        } else if (dataTypeName.equalsIgnoreCase("INTEGER")) {
            returnTypeName = this.getIntType();
        } else if (dataTypeName.equalsIgnoreCase("LONGVARBINARY")) {
            returnTypeName = this.getBlobType();
        } else if (dataTypeName.equalsIgnoreCase("LONGVARCHAR")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("TEXT")) {
            returnTypeName = this.getClobType();
        } else if (dataTypeName.equalsIgnoreCase("TIME")) {
            returnTypeName = this.getTimeType();
        } else if (dataTypeName.equalsIgnoreCase("TIMESTAMP")) {
            returnTypeName = this.getDateTimeType();
        } else if (dataTypeName.equalsIgnoreCase("TINYINT")) {
            returnTypeName = this.getTinyIntType();
        } else if (dataTypeName.equalsIgnoreCase("UUID")) {
            returnTypeName = this.getUUIDType();
        } else if (dataTypeName.equalsIgnoreCase("VARCHAR")) {
            returnTypeName = this.getVarcharType();
        } else if (columnType.startsWith("java.sql.Types")) {
            returnTypeName = this.getTypeFromMetaData(dataTypeName);
        } else {
            return columnType;
        }
        if (precision != null && returnTypeName.getSupportsPrecision().booleanValue()) {
            return new StringBuffer().append(returnTypeName.getDataTypeName()).append("(").append(precision).append(")").toString();
        }
        return returnTypeName.getDataTypeName();
    }

    private DataType getTypeFromMetaData(String dataTypeName) {
        ResultSet resultSet = null;
        try {
            Integer requestedType = (Integer)Class.forName("java.sql.Types").getDeclaredField(dataTypeName).get(null);
            DatabaseConnection connection = this.getConnection();
            if (connection == null) {
                throw new RuntimeException("Cannot evaluate java.sql.Types without a connection");
            }
            resultSet = connection.getMetaData().getTypeInfo();
            while (resultSet.next()) {
                String typeName = resultSet.getString("TYPE_NAME");
                int dataType = resultSet.getInt("DATA_TYPE");
                int maxPrecision = resultSet.getInt("PRECISION");
                if (requestedType != dataType) continue;
                if (maxPrecision > 0) {
                    DataType dataType2 = new DataType(typeName, true);
                    return dataType2;
                }
                DataType dataType3 = new DataType(typeName, false);
                return dataType3;
            }
            DataType dataType = null;
            return dataType;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public final String getColumnType(ColumnConfig columnConfig) {
        return this.getColumnType(columnConfig.getType(), columnConfig.isAutoIncrement());
    }

    @Override
    public String getFalseBooleanValue() {
        return "false";
    }

    @Override
    public String getTrueBooleanValue() {
        return "true";
    }

    @Override
    public String getDateLiteral(String isoDate) {
        if (this.isDateOnly(isoDate) || this.isTimeOnly(isoDate)) {
            return new StringBuffer().append("'").append(isoDate).append("'").toString();
        }
        if (this.isDateTime(isoDate)) {
            return new StringBuffer().append("'").append(isoDate.replace('T', ' ')).append("'").toString();
        }
        return new StringBuffer().append("BAD_DATE_FORMAT:").append(isoDate).toString();
    }

    @Override
    public String getDateLiteral(Timestamp date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Date date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(Time date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    @Override
    public String getDateLiteral(java.util.Date date) {
        if (date instanceof Date) {
            return this.getDateLiteral((Date)date);
        }
        if (date instanceof Time) {
            return this.getDateLiteral((Time)date);
        }
        if (date instanceof Timestamp) {
            return this.getDateLiteral((Timestamp)date);
        }
        if (date instanceof ComputedDateValue) {
            return date.toString();
        }
        throw new RuntimeException(new StringBuffer().append("Unexpected type: ").append(date.getClass().getName()).toString());
    }

    protected java.util.Date parseDate(String dateAsString) throws DateParseException {
        try {
            if (dateAsString.indexOf(" ") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf("T") > 0) {
                return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(dateAsString);
            }
            if (dateAsString.indexOf(":") > 0) {
                return new SimpleDateFormat("HH:mm:ss").parse(dateAsString);
            }
            return new SimpleDateFormat("yyyy-MM-dd").parse(dateAsString);
        }
        catch (ParseException e) {
            throw new DateParseException(dateAsString);
        }
    }

    protected boolean isDateOnly(String isoDate) {
        return isoDate.length() == "yyyy-MM-dd".length();
    }

    protected boolean isDateTime(String isoDate) {
        return isoDate.length() >= "yyyy-MM-ddThh:mm:ss".length();
    }

    protected boolean isTimeOnly(String isoDate) {
        return isoDate.length() == "hh:mm:ss".length();
    }

    @Override
    public DataType getDateType() {
        return DATE_TYPE;
    }

    @Override
    public DataType getTimeType() {
        return TIME_TYPE;
    }

    @Override
    public DataType getBigIntType() {
        return BIGINT_TYPE;
    }

    @Override
    public DataType getCharType() {
        return CHAR_TYPE;
    }

    @Override
    public DataType getVarcharType() {
        return VARCHAR_TYPE;
    }

    @Override
    public DataType getFloatType() {
        return FLOAT_TYPE;
    }

    @Override
    public DataType getDoubleType() {
        return DOUBLE_TYPE;
    }

    @Override
    public DataType getIntType() {
        return INT_TYPE;
    }

    @Override
    public DataType getTinyIntType() {
        return TINYINT_TYPE;
    }

    @Override
    public String getLineComment() {
        return "--";
    }

    @Override
    public String getAutoIncrementClause() {
        return "AUTO_INCREMENT";
    }

    @Override
    public String getConcatSql(String[] values) {
        StringBuffer returnString = new StringBuffer();
        for (String value : values) {
            returnString.append(value).append(" || ");
        }
        return returnString.toString().replaceFirst(" \\|\\| $", "");
    }

    @Override
    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    @Override
    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    @Override
    public void setDatabaseChangeLogTableName(String tableName) {
        this.databaseChangeLogTableName = tableName;
    }

    @Override
    public void setDatabaseChangeLogLockTableName(String tableName) {
        this.databaseChangeLogLockTableName = tableName;
    }

    private SqlStatement getChangeLogLockInsertSQL() {
        return new InsertStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()).addColumnValue("ID", _Integer.valueOf(1)).addColumnValue("LOCKED", Boolean.FALSE);
    }

    protected SqlStatement getCreateChangeLogLockSQL() {
        return new CreateTableStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName()).addPrimaryKeyColumn("ID", "INT", null, null, new ColumnConstraint[]{new NotNullConstraint()}).addColumn("LOCKED", this.getBooleanType().getDataTypeName(), new ColumnConstraint[]{new NotNullConstraint()}).addColumn("LOCKGRANTED", this.getDateTimeType().getDataTypeName()).addColumn("LOCKEDBY", "VARCHAR(255)");
    }

    protected SqlStatement getCreateChangeLogSQL() {
        return new CreateTableStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName()).addPrimaryKeyColumn("ID", "VARCHAR(63)", null, null, new ColumnConstraint[]{new NotNullConstraint()}).addPrimaryKeyColumn("AUTHOR", "VARCHAR(63)", null, null, new ColumnConstraint[]{new NotNullConstraint()}).addPrimaryKeyColumn("FILENAME", "VARCHAR(200)", null, null, new ColumnConstraint[]{new NotNullConstraint()}).addColumn("DATEEXECUTED", this.getDateTimeType().getDataTypeName(), new ColumnConstraint[]{new NotNullConstraint()}).addColumn("MD5SUM", "VARCHAR(32)").addColumn("DESCRIPTION", "VARCHAR(255)").addColumn("COMMENTS", "VARCHAR(255)").addColumn("TAG", "VARCHAR(255)").addColumn("LIQUIBASE", "VARCHAR(10)");
    }

    @Override
    public SqlStatement getSelectChangeLogLockSQL() throws JDBCException {
        return new RawSqlStatement(new StringBuffer().append("SELECT LOCKED FROM ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName())).append(" WHERE ").append(this.escapeColumnName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName(), "ID")).append("=1").toString());
    }

    @Override
    public boolean doesChangeLogTableExist() throws JDBCException {
        DatabaseConnection connection = this.getConnection();
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getTables(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogTableName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.warning(new StringBuffer().append("Error closing result set: ").append(e.getMessage()).toString());
                }
            }
        }
    }

    @Override
    public void checkDatabaseChangeLogTable() throws JDBCException {
        if (!this.getJdbcTemplate().executesStatements()) {
            if (((JdbcOutputTemplate)this.getJdbcTemplate()).alreadyCreatedChangeTable()) {
                return;
            }
            ((JdbcOutputTemplate)this.getJdbcTemplate()).setAlreadyCreatedChangeTable(true);
        }
        DatabaseConnection connection = this.getConnection();
        ResultSet checkColumnsRS = null;
        ArrayList<SqlStatement> statementsToExecute = new ArrayList<SqlStatement>();
        boolean changeLogCreateAttempted = false;
        try {
            if (this.doesChangeLogTableExist()) {
                checkColumnsRS = connection.getMetaData().getColumns(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogTableName(), null);
                boolean hasDescription = false;
                boolean hasComments = false;
                boolean hasTag = false;
                boolean hasLiquibase = false;
                while (checkColumnsRS.next()) {
                    String columnName = checkColumnsRS.getString("COLUMN_NAME");
                    if ("DESCRIPTION".equalsIgnoreCase(columnName)) {
                        hasDescription = true;
                        continue;
                    }
                    if ("COMMENTS".equalsIgnoreCase(columnName)) {
                        hasComments = true;
                        continue;
                    }
                    if ("TAG".equalsIgnoreCase(columnName)) {
                        hasTag = true;
                        continue;
                    }
                    if (!"LIQUIBASE".equalsIgnoreCase(columnName)) continue;
                    hasLiquibase = true;
                }
                if (!hasDescription) {
                    statementsToExecute.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "DESCRIPTION", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!hasTag) {
                    statementsToExecute.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "TAG", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!hasComments) {
                    statementsToExecute.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "COMMENTS", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
                if (!hasLiquibase) {
                    statementsToExecute.add(new AddColumnStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName(), "LIQUIBASE", "VARCHAR(255)", null, new ColumnConstraint[0]));
                }
            } else if (!changeLogCreateAttempted) {
                this.getJdbcTemplate().comment("Create Database Change Log Table");
                SqlStatement createTableStatement = this.getCreateChangeLogSQL();
                if (!this.canCreateChangeLogTable()) {
                    throw new JDBCException(new StringBuffer().append("Cannot create ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).append(" table for your database.\n\n").append("Please construct it manually using the following SQL as a base and re-run LiquiBase:\n\n").append(createTableStatement).toString());
                }
                statementsToExecute.add(createTableStatement);
                log.info(new StringBuffer().append("Creating database history table with name: ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).toString());
            }
            for (SqlStatement sql : statementsToExecute) {
                this.getJdbcTemplate().execute(sql, new ArrayList<SqlVisitor>());
                this.commit();
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
        finally {
            if (checkColumnsRS != null) {
                try {
                    checkColumnsRS.close();
                }
                catch (SQLException e) {
                    throw new JDBCException(e);
                }
            }
        }
    }

    protected boolean canCreateChangeLogTable() throws JDBCException {
        return true;
    }

    @Override
    public boolean doesChangeLogLockTableExist() throws JDBCException {
        DatabaseConnection connection = this.getConnection();
        ResultSet rs = null;
        try {
            rs = connection.getMetaData().getTables(this.convertRequestedSchemaToCatalog(this.getDefaultSchemaName()), this.convertRequestedSchemaToSchema(this.getDefaultSchemaName()), this.getDatabaseChangeLogLockTableName(), new String[]{"TABLE"});
            boolean bl = rs.next();
            return bl;
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.warning(new StringBuffer().append("Error closing result set: ").append(e.getMessage()).toString());
                }
            }
        }
    }

    @Override
    public void checkDatabaseChangeLogLockTable() throws JDBCException {
        boolean knowMustInsertIntoLockTable = false;
        if (!this.doesChangeLogLockTableExist()) {
            if (!this.getJdbcTemplate().executesStatements()) {
                if (((JdbcOutputTemplate)this.getJdbcTemplate()).alreadyCreatedChangeLockTable()) {
                    return;
                }
                ((JdbcOutputTemplate)this.getJdbcTemplate()).setAlreadyCreatedChangeLockTable(true);
            }
            SqlStatement createTableStatement = this.getCreateChangeLogLockSQL();
            this.getJdbcTemplate().comment("Create Database Lock Table");
            this.getJdbcTemplate().execute(createTableStatement, new ArrayList<SqlVisitor>());
            this.commit();
            log.finest(new StringBuffer().append("Created database lock table with name: ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName())).toString());
            knowMustInsertIntoLockTable = true;
        }
        int rows = -1;
        if (!knowMustInsertIntoLockTable) {
            RawSqlStatement selectStatement = new RawSqlStatement(new StringBuffer().append("SELECT COUNT(*) FROM ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName())).append(" WHERE ID=1").toString());
            rows = this.getJdbcTemplate().queryForInt(selectStatement, new ArrayList<SqlVisitor>());
        }
        if (knowMustInsertIntoLockTable || rows == 0) {
            this.getJdbcTemplate().update(this.getChangeLogLockInsertSQL(), new ArrayList<SqlVisitor>());
            this.commit();
            log.fine(new StringBuffer().append("Inserted lock row into: ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogLockTableName())).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropDatabaseObjects(String schema) throws JDBCException {
        try {
            AbstractChange dropChange;
            DatabaseSnapshot snapshot = this.createDatabaseSnapshot(schema, new HashSet<DiffStatusListener>());
            ArrayList<AbstractChange> dropChanges = new ArrayList<AbstractChange>();
            for (View view : snapshot.getViews()) {
                dropChange = new DropViewChange();
                ((DropViewChange)dropChange).setViewName(view.getName());
                ((DropViewChange)dropChange).setSchemaName(schema);
                dropChanges.add(dropChange);
            }
            for (ForeignKey foreignKey : snapshot.getForeignKeys()) {
                DropForeignKeyConstraintChange dropFK = new DropForeignKeyConstraintChange();
                dropFK.setBaseTableSchemaName(schema);
                dropFK.setBaseTableName(foreignKey.getForeignKeyTable().getName());
                dropFK.setConstraintName(foreignKey.getName());
                dropChanges.add(dropFK);
            }
            for (Table table : snapshot.getTables()) {
                dropChange = new DropTableChange();
                ((DropTableChange)dropChange).setSchemaName(schema);
                ((DropTableChange)dropChange).setTableName(table.getName());
                ((DropTableChange)dropChange).setCascadeConstraints(true);
                dropChanges.add(dropChange);
            }
            if (this.supportsSequences()) {
                for (Sequence sequence : snapshot.getSequences()) {
                    dropChange = new DropSequenceChange();
                    ((DropSequenceChange)dropChange).setSequenceName(sequence.getName());
                    ((DropSequenceChange)dropChange).setSchemaName(schema);
                    dropChanges.add(dropChange);
                }
            }
            if (snapshot.hasDatabaseChangeLogTable()) {
                RawSQLChange clearChangeLogChange = new RawSQLChange();
                clearChangeLogChange.setSql(new StringBuffer().append("DELETE FROM ").append(this.escapeTableName(this.convertRequestedSchemaToSchema(schema), this.getDatabaseChangeLogTableName())).toString());
                dropChanges.add(clearChangeLogChange);
            }
            try {
                for (Change change : dropChanges) {
                    for (SqlStatement statement : change.generateStatements(this)) {
                        this.getJdbcTemplate().execute(statement, new ArrayList<SqlVisitor>());
                    }
                }
            }
            catch (UnsupportedChangeException e) {
                throw new JDBCException(e);
            }
        }
        finally {
            this.commit();
        }
    }

    @Override
    public boolean isSystemTable(String catalogName, String schemaName, String tableName) {
        if ("information_schema".equalsIgnoreCase(schemaName)) {
            return true;
        }
        if (tableName.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName())) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(tableName);
    }

    @Override
    public boolean isSystemView(String catalogName, String schemaName, String viewName) {
        if ("information_schema".equalsIgnoreCase(schemaName)) {
            return true;
        }
        return this.getSystemTablesAndViews().contains(viewName);
    }

    @Override
    public boolean isLiquibaseTable(String tableName) {
        return tableName.equalsIgnoreCase(this.getDatabaseChangeLogTableName()) || tableName.equalsIgnoreCase(this.getDatabaseChangeLogLockTableName());
    }

    @Override
    public void tag(String tagString) throws JDBCException {
        try {
            int totalRows = this.getJdbcTemplate().queryForInt(new RawSqlStatement(new StringBuffer().append("SELECT COUNT(*) FROM ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).toString()), new ArrayList<SqlVisitor>());
            if (totalRows == 0) {
                throw new JDBCException("Cannot tag an empty database");
            }
            int rowsUpdated = this.getJdbcTemplate().update(new TagDatabaseStatement(tagString), new ArrayList<SqlVisitor>());
            if (rowsUpdated == 0) {
                throw new JDBCException("Did not tag database change log correctly");
            }
            this.commit();
        }
        catch (Exception e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public SqlStatement createFindSequencesSQL(String schema) throws JDBCException {
        return null;
    }

    @Override
    public boolean doesTagExist(String tag) throws JDBCException {
        int count = this.getJdbcTemplate().queryForInt(new RawSqlStatement(new StringBuffer().append("SELECT COUNT(*) FROM ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).append(" WHERE TAG='").append(tag).append("'").toString()), new ArrayList<SqlVisitor>());
        return count > 0;
    }

    public String toString() {
        if (this.getConnection() == null) {
            return new StringBuffer().append(this.getProductName()).append(" Database").toString();
        }
        try {
            return new StringBuffer().append(this.getConnectionUsername()).append(" @ ").append(this.getConnectionURL()).append(this.getDefaultSchemaName() == null ? "" : new StringBuffer().append(" (Default Schema: ").append(this.getDefaultSchemaName()).append(")").toString()).toString();
        }
        catch (JDBCException e) {
            return super.toString();
        }
    }

    @Override
    public boolean shouldQuoteValue(String value) {
        return true;
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws JDBCException {
        String definition;
        if (schemaName == null) {
            schemaName = this.convertRequestedSchemaToSchema(null);
        }
        JdbcTemplate jdbcTemplate = this.getJdbcTemplate();
        SqlStatement sqlStatement = this.getViewDefinitionSql(schemaName, viewName);
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        if ((definition = (String)jdbcTemplate.queryForObject(sqlStatement, clazz, new ArrayList<SqlVisitor>())) == null) {
            return null;
        }
        return CREATE_VIEW_AS_PATTERN.matcher(definition).replaceFirst("");
    }

    public SqlStatement getViewDefinitionSql(String schemaName, String viewName) throws JDBCException {
        String sql = new StringBuffer().append("select view_definition from information_schema.views where upper(table_name)='").append(viewName.toUpperCase()).append("'").toString();
        if (this.convertRequestedSchemaToCatalog(schemaName) != null) {
            sql = new StringBuffer().append(sql).append(" and table_schema='").append(this.convertRequestedSchemaToSchema(schemaName)).append("'").toString();
        } else if (this.convertRequestedSchemaToCatalog(schemaName) != null) {
            sql = new StringBuffer().append(sql).append(" and table_catalog='").append(this.convertRequestedSchemaToCatalog(schemaName)).append("'").toString();
        }
        log.finest(new StringBuffer().append("GetViewDefinitionSQL: ").append(sql).toString());
        return new RawSqlStatement(sql);
    }

    @Override
    public int getDatabaseType(int type) {
        String booleanType;
        int returnType = type;
        if (returnType == 16 && !(booleanType = this.getBooleanType().getDataTypeName()).equalsIgnoreCase("boolean")) {
            returnType = -6;
        }
        return returnType;
    }

    @Override
    public Object convertDatabaseValueToJavaObject(Object defaultValue, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (defaultValue == null) {
            return null;
        }
        if (defaultValue instanceof String) {
            return this.convertToCorrectJavaType(((String)defaultValue).replaceFirst("^'", "").replaceFirst("'$", ""), dataType, columnSize, decimalDigits);
        }
        return defaultValue;
    }

    protected Object convertToCorrectJavaType(String value, int dataType, int columnSize, int decimalDigits) throws ParseException {
        if (value == null) {
            return null;
        }
        if (dataType == 2005 || dataType == 12 || dataType == 1 || dataType == -1) {
            if (value.equalsIgnoreCase("NULL")) {
                return null;
            }
            return value;
        }
        if ((value = StringUtils.trimToNull(value)) == null) {
            return null;
        }
        try {
            if (dataType == 91) {
                return new Date(this.parseDate(value).getTime());
            }
            if (dataType == 93) {
                return new Timestamp(this.parseDate(value).getTime());
            }
            if (dataType == 92) {
                return new Time(this.parseDate(value).getTime());
            }
            if (dataType == -5) {
                return new BigInteger(value);
            }
            if (dataType == -7) {
                if ((value = value.replaceFirst("b'", "")).equalsIgnoreCase("true")) {
                    return Boolean.TRUE;
                }
                if (value.equalsIgnoreCase("false")) {
                    return Boolean.FALSE;
                }
                if (value.equals("1")) {
                    return Boolean.TRUE;
                }
                if (value.equals("0")) {
                    return Boolean.FALSE;
                }
                if (value.equals("(1)")) {
                    return Boolean.TRUE;
                }
                if (value.equals("(0)")) {
                    return Boolean.FALSE;
                }
                throw new ParseException(new StringBuffer().append("Unknown bit value: ").append(value).toString(), 0);
            }
            if (dataType == 16) {
                return Boolean.valueOf(value);
            }
            if (dataType == 3) {
                if (decimalDigits == 0) {
                    return new Integer(value);
                }
                return new Double(value);
            }
            if (dataType == 8 || dataType == 2) {
                return new Double(value);
            }
            if (dataType == 6) {
                return new Float(value);
            }
            if (dataType == 4) {
                return new Integer(value);
            }
            if (dataType == 0) {
                return null;
            }
            if (dataType == 7) {
                return new Float(value);
            }
            if (dataType == 5) {
                return new Integer(value);
            }
            if (dataType == -6) {
                return new Integer(value);
            }
            if (dataType == 2004) {
                return "!!!!!! LIQUIBASE CANNOT OUTPUT BLOB VALUES !!!!!!";
            }
            log.warning(new StringBuffer().append("Do not know how to convert type ").append(dataType).toString());
            return value;
        }
        catch (DateParseException e) {
            return new ComputedDateValue(value);
        }
        catch (NumberFormatException e) {
            return new ComputedNumericValue(value);
        }
    }

    @Override
    public String convertJavaObjectToString(Object value) {
        if (value != null) {
            if (value instanceof String) {
                if ("null".equalsIgnoreCase((String)value)) {
                    return null;
                }
                return new StringBuffer().append("'").append(((String)value).replaceAll("'", "''")).append("'").toString();
            }
            if (value instanceof Number) {
                return value.toString();
            }
            if (value instanceof Boolean) {
                String returnValue = (Boolean)value != false ? this.getTrueBooleanValue() : this.getFalseBooleanValue();
                if (returnValue.matches("\\d+")) {
                    return returnValue;
                }
                return new StringBuffer().append("'").append(returnValue).append("'").toString();
            }
            if (value instanceof Date) {
                return this.getDateLiteral((Date)value);
            }
            if (value instanceof Time) {
                return this.getDateLiteral((Time)value);
            }
            if (value instanceof Timestamp) {
                return this.getDateLiteral((Timestamp)value);
            }
            if (value instanceof ComputedDateValue) {
                return ((ComputedDateValue)value).getValue();
            }
            throw new RuntimeException(new StringBuffer().append("Unknown default value type: ").append(value.getClass().getName()).toString());
        }
        return null;
    }

    @Override
    public String escapeTableName(String schemaName, String tableName) {
        if (StringUtils.trimToNull(schemaName) == null || !this.supportsSchemas()) {
            return new StringBuffer().append(this.getObjectEscapeCharacter()).append(tableName).append(this.getObjectEscapeCharacter()).toString();
        }
        return new StringBuffer().append(this.getObjectEscapeCharacter()).append(schemaName).append(this.getObjectEscapeCharacter()).append(".").append(this.getObjectEscapeCharacter()).append(tableName).append(this.getObjectEscapeCharacter()).toString();
    }

    public String getObjectEscapeCharacter() {
        return "";
    }

    @Override
    public String escapeIndexName(String schemaName, String indexName) {
        return this.escapeTableName(schemaName, indexName);
    }

    @Override
    public String escapeSequenceName(String schemaName, String sequenceName) {
        if (StringUtils.trimToNull(schemaName) == null || !this.supportsSchemas()) {
            return new StringBuffer().append(this.getObjectEscapeCharacter()).append(sequenceName).append(this.getObjectEscapeCharacter()).toString();
        }
        return new StringBuffer().append(this.getObjectEscapeCharacter()).append(schemaName).append(this.getObjectEscapeCharacter()).append(".").append(this.getObjectEscapeCharacter()).append(sequenceName).append(this.getObjectEscapeCharacter()).toString();
    }

    @Override
    public String escapeConstraintName(String constraintName) {
        return new StringBuffer().append(this.getObjectEscapeCharacter()).append(constraintName).append(this.getObjectEscapeCharacter()).toString();
    }

    @Override
    public String escapeColumnName(String schemaName, String tableName, String columnName) {
        return new StringBuffer().append(this.getObjectEscapeCharacter()).append(columnName).append(this.getObjectEscapeCharacter()).toString();
    }

    @Override
    public String escapeColumnNameList(String columnNames) {
        return columnNames;
    }

    @Override
    public String convertRequestedSchemaToCatalog(String requestedSchema) throws JDBCException {
        if (this.getDefaultCatalogName() == null) {
            return null;
        }
        if (requestedSchema == null) {
            return this.getDefaultCatalogName();
        }
        return StringUtils.trimToNull(requestedSchema);
    }

    @Override
    public String convertRequestedSchemaToSchema(String requestedSchema) throws JDBCException {
        String returnSchema = requestedSchema;
        if (returnSchema == null) {
            returnSchema = this.getDefaultDatabaseSchemaName();
        }
        if (returnSchema != null) {
            returnSchema = returnSchema.toUpperCase();
        }
        return returnSchema;
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public String generatePrimaryKeyName(String tableName) {
        return new StringBuffer().append("PK_").append(tableName.toUpperCase()).toString();
    }

    @Override
    public String escapeViewName(String schemaName, String viewName) {
        return this.escapeTableName(schemaName, viewName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isColumnAutoIncrement(String schemaName, String tableName, String columnName) throws SQLException, JDBCException {
        if (!this.supportsAutoIncrement()) {
            return false;
        }
        boolean autoIncrement = false;
        ResultSet selectRS = null;
        try {
            selectRS = this.getConnection().createStatement().executeQuery(new StringBuffer().append("SELECT ").append(this.escapeColumnName(schemaName, tableName, columnName)).append(" FROM ").append(this.escapeTableName(schemaName, tableName)).append(" WHERE 1 = 0").toString());
            ResultSetMetaData meta = selectRS.getMetaData();
            autoIncrement = meta.isAutoIncrement(1);
        }
        finally {
            if (selectRS != null) {
                selectRS.close();
            }
        }
        return autoIncrement;
    }

    @Override
    public ChangeSet.RunStatus getRunStatus(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        if (!this.doesChangeLogTableExist()) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        RanChangeSet foundRan = this.getRanChangeSet(changeSet);
        if (foundRan == null) {
            return ChangeSet.RunStatus.NOT_RAN;
        }
        if (foundRan.getMd5sum() == null) {
            try {
                log.info(new StringBuffer().append("Updating NULL md5sum for ").append(changeSet.toString()).toString());
                DatabaseConnection connection = this.getConnection();
                PreparedStatement updatePstmt = connection.prepareStatement(new StringBuffer().append("UPDATE ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).append(" SET MD5SUM=? WHERE ID=? AND AUTHOR=? AND FILENAME=?").toString());
                updatePstmt.setString(1, changeSet.getMd5sum());
                updatePstmt.setString(2, changeSet.getId());
                updatePstmt.setString(3, changeSet.getAuthor());
                updatePstmt.setString(4, changeSet.getFilePath());
                updatePstmt.executeUpdate();
                updatePstmt.close();
                this.commit();
            }
            catch (SQLException e) {
                throw new JDBCException(e);
            }
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (foundRan.getMd5sum().equals(changeSet.getMd5sum())) {
            return ChangeSet.RunStatus.ALREADY_RAN;
        }
        if (changeSet.shouldRunOnChange()) {
            return ChangeSet.RunStatus.RUN_AGAIN;
        }
        return ChangeSet.RunStatus.INVALID_MD5SUM;
    }

    @Override
    public RanChangeSet getRanChangeSet(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        if (!this.doesChangeLogTableExist()) {
            throw new DatabaseHistoryException("Database change table does not exist");
        }
        RanChangeSet foundRan = null;
        for (RanChangeSet ranChange : this.getRanChangeSetList()) {
            if (!ranChange.isSameAs(changeSet)) continue;
            foundRan = ranChange;
            break;
        }
        return foundRan;
    }

    @Override
    public List<RanChangeSet> getRanChangeSetList() throws JDBCException {
        if (this.ranChangeSetList != null) {
            return this.ranChangeSetList;
        }
        try {
            String databaseChangeLogTableName = this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName());
            this.ranChangeSetList = new ArrayList<RanChangeSet>();
            if (this.doesChangeLogTableExist()) {
                log.info(new StringBuffer().append("Reading from ").append(databaseChangeLogTableName).toString());
                String sql = new StringBuffer().append("SELECT * FROM ").append(databaseChangeLogTableName).append(" ORDER BY DATEEXECUTED ASC".toUpperCase()).toString();
                Statement statement = this.getConnection().createStatement();
                ResultSet rs = statement.executeQuery(sql);
                while (rs.next()) {
                    String fileName = rs.getString("FILENAME");
                    String author = rs.getString("AUTHOR");
                    String id = rs.getString("ID");
                    String md5sum = rs.getString("MD5SUM");
                    Timestamp dateExecuted = rs.getTimestamp("DATEEXECUTED");
                    String tag = rs.getString("TAG");
                    RanChangeSet ranChangeSet = new RanChangeSet(fileName, id, author, md5sum, dateExecuted, tag);
                    this.ranChangeSetList.add(ranChangeSet);
                }
                rs.close();
                statement.close();
            }
            return this.ranChangeSetList;
        }
        catch (SQLException e) {
            if (!this.getJdbcTemplate().executesStatements()) {
                return new ArrayList<RanChangeSet>();
            }
            throw new JDBCException(e);
        }
    }

    @Override
    public java.util.Date getRanDate(ChangeSet changeSet) throws JDBCException, DatabaseHistoryException {
        RanChangeSet ranChange = this.getRanChangeSet(changeSet);
        if (ranChange == null) {
            return null;
        }
        return ranChange.getDateExecuted();
    }

    @Override
    public void markChangeSetAsRan(ChangeSet changeSet) throws JDBCException {
        String dateValue = this.getCurrentDateTimeFunction();
        InsertStatement statement = new InsertStatement(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName());
        statement.addColumnValue("ID", this.escapeStringForDatabase(changeSet.getId()));
        statement.addColumnValue("AUTHOR", changeSet.getAuthor());
        statement.addColumnValue("FILENAME", changeSet.getFilePath());
        statement.addColumnValue("DATEEXECUTED", new ComputedDateValue(dateValue));
        statement.addColumnValue("MD5SUM", changeSet.getMd5sum());
        statement.addColumnValue("DESCRIPTION", this.limitSize(changeSet.getDescription()));
        statement.addColumnValue("COMMENTS", this.limitSize(StringUtils.trimToEmpty(changeSet.getComments())));
        statement.addColumnValue("LIQUIBASE", LiquibaseUtil.getBuildVersion());
        this.getJdbcTemplate().execute(statement, new ArrayList<SqlVisitor>());
        this.getRanChangeSetList().add(new RanChangeSet(changeSet));
    }

    @Override
    public void markChangeSetAsReRan(ChangeSet changeSet) throws JDBCException {
        String dateValue = this.getCurrentDateTimeFunction();
        String sql = new StringBuffer().append("UPDATE ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).append(" SET DATEEXECUTED=").append(dateValue).append(", MD5SUM='?' WHERE ID='?' AND AUTHOR='?' AND FILENAME='?'").toString();
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getMd5sum()));
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getId()));
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getAuthor()));
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getFilePath()));
        this.getJdbcTemplate().execute(new RawSqlStatement(sql), new ArrayList<SqlVisitor>());
        this.commit();
    }

    @Override
    public void removeRanStatus(ChangeSet changeSet) throws JDBCException {
        String sql = new StringBuffer().append("DELETE FROM ").append(this.escapeTableName(this.getDefaultSchemaName(), this.getDatabaseChangeLogTableName())).append(" WHERE ID='?' AND AUTHOR='?' AND FILENAME='?'").toString();
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getId()));
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getAuthor()));
        sql = sql.replaceFirst("\\?", this.escapeStringForDatabase(changeSet.getFilePath()));
        this.getJdbcTemplate().execute(new RawSqlStatement(sql), new ArrayList<SqlVisitor>());
        this.commit();
        this.getRanChangeSetList().remove(new RanChangeSet(changeSet));
    }

    @Override
    public String escapeStringForDatabase(String string) {
        return string.replaceAll("'", "''");
    }

    private String limitSize(String string) {
        int maxLength = 255;
        if (string.length() > maxLength) {
            return new StringBuffer().append(string.substring(0, maxLength - 3)).append("...").toString();
        }
        return string;
    }

    @Override
    public void commit() throws JDBCException {
        try {
            this.getConnection().commit();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public void rollback() throws JDBCException {
        try {
            this.getConnection().rollback();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    @Override
    public void setJdbcTemplate(JdbcTemplate template) {
        if (this.jdbcTemplate != null && !this.jdbcTemplate.executesStatements() && template.executesStatements()) {
            LockHandler.getInstance(this).reset();
        }
        this.jdbcTemplate = template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractDatabase that = (AbstractDatabase)o;
        return !(this.connection == null ? that.connection != null : !this.connection.equals(that.connection));
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : 0;
    }

    @Override
    public void close() throws JDBCException {
        try {
            DatabaseConnection connection = this.getConnection();
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public abstract DatabaseSnapshot createDatabaseSnapshot(String var1, Set<DiffStatusListener> var2) throws JDBCException;

    @Override
    public boolean supportsRestrictForeignKeys() {
        return true;
    }

    @Override
    public boolean isAutoCommit() throws JDBCException {
        try {
            return this.getConnection().getAutoCommit();
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public void setAutoCommit(boolean b) throws JDBCException {
        try {
            this.getConnection().setAutoCommit(b);
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public boolean isLocalDatabase() throws JDBCException {
        String url = this.getConnectionURL();
        return url.indexOf("localhost") >= 0 || url.indexOf("127.0.0.1") >= 0;
    }
}

