/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.List;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyRowsStatement
implements SqlStatement {
    private String sourceTable;
    private String targetTable;
    private List<ColumnConfig> copyColumns;

    public CopyRowsStatement(String sourceTable, String targetTable, List<ColumnConfig> copyColumns) {
        this.sourceTable = sourceTable;
        this.targetTable = targetTable;
        this.copyColumns = copyColumns;
    }

    public String getSourceTable() {
        return this.sourceTable;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public List<ColumnConfig> getCopyColumns() {
        return this.copyColumns;
    }

    @Override
    public String getEndDelimiter(Database database) {
        return ";";
    }

    @Override
    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        StringBuffer sql = new StringBuffer();
        if (database instanceof SQLiteDatabase) {
            sql.append(new StringBuffer().append("INSERT INTO `").append(this.getTargetTable()).append("` SELECT ").toString());
            for (int i = 0; i < this.getCopyColumns().size(); ++i) {
                ColumnConfig column = this.getCopyColumns().get(i);
                if (i > 0) {
                    sql.append(",");
                }
                sql.append(new StringBuffer().append("`").append(column.getName()).append("`").toString());
            }
            sql.append(new StringBuffer().append(" FROM `").append(this.getSourceTable()).append("`").toString());
        }
        return sql.toString();
    }

    @Override
    public boolean supportsDatabase(Database database) {
        return database instanceof SQLiteDatabase;
    }
}

