/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.template;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.sql.CallableSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.CallableStatementCallback;
import liquibase.database.template.JdbcTemplate;
import liquibase.database.template.StatementCallback;
import liquibase.exception.JDBCException;
import liquibase.util.StreamUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcOutputTemplate
extends JdbcTemplate {
    private Writer output;
    private boolean alreadyCreatedChangeLockTable;
    private boolean alreadyCreatedChangeTable;

    public JdbcOutputTemplate(Writer output, Database database) {
        super(database);
        this.output = output;
    }

    @Override
    public boolean executesStatements() {
        return false;
    }

    @Override
    public void execute(SqlStatement sql) throws JDBCException {
        this.outputStatement(sql);
    }

    @Override
    public int update(SqlStatement sql) throws JDBCException {
        this.outputStatement(sql);
        return 0;
    }

    @Override
    public Object execute(StatementCallback action, List<SqlVisitor> sqlVisitors) throws JDBCException {
        this.outputStatement(action.getStatement(), sqlVisitors);
        return null;
    }

    @Override
    public void execute(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        this.outputStatement(sql, sqlVisitors);
    }

    @Override
    public int update(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        this.outputStatement(sql, sqlVisitors);
        return 0;
    }

    @Override
    public Object execute(CallableSqlStatement csc, CallableStatementCallback action, List<SqlVisitor> sqlVisitors) throws JDBCException {
        throw new JDBCException("Do not know how to output callable statement");
    }

    @Override
    public Map call(CallableSqlStatement csc, List declaredParameters, List<SqlVisitor> sqlVisitors) throws JDBCException {
        throw new JDBCException("Do not know how to output callable statement");
    }

    @Override
    public void comment(String message) throws JDBCException {
        try {
            this.output.write(this.database.getLineComment());
            this.output.write(" ");
            this.output.write(message);
            this.output.write(StreamUtil.getLineSeparator());
        }
        catch (IOException e) {
            throw new JDBCException(e);
        }
    }

    private void outputStatement(SqlStatement sql) throws JDBCException {
    }

    private void outputStatement(SqlStatement sql, List<SqlVisitor> sqlVisitors) throws JDBCException {
        try {
            String statement = this.applyVisitors(sql, sqlVisitors);
            this.output.write(statement);
            if (this.database instanceof MSSQLDatabase) {
                this.output.write(StreamUtil.getLineSeparator());
                this.output.write("GO");
            } else if (!statement.endsWith(";")) {
                this.output.write(";");
            }
            this.output.write(StreamUtil.getLineSeparator());
            this.output.write(StreamUtil.getLineSeparator());
        }
        catch (IOException e) {
            throw new JDBCException(e);
        }
    }

    public boolean alreadyCreatedChangeLockTable() {
        return this.alreadyCreatedChangeLockTable;
    }

    public void setAlreadyCreatedChangeLockTable(boolean alreadyCreatedChangeLockTable) {
        this.alreadyCreatedChangeLockTable = alreadyCreatedChangeLockTable;
    }

    public boolean alreadyCreatedChangeTable() {
        return this.alreadyCreatedChangeTable;
    }

    public void setAlreadyCreatedChangeTable(boolean alreadyCreatedChangeTable) {
        this.alreadyCreatedChangeTable = alreadyCreatedChangeTable;
    }
}

