/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.AddForeignKeyConstraintChange;
import liquibase.change.AddNotNullConstraintChange;
import liquibase.change.AddPrimaryKeyChange;
import liquibase.change.Change;
import liquibase.change.DropForeignKeyConstraintChange;
import liquibase.change.DropTableChange;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddLookupTableChange
extends AbstractChange {
    private String existingTableSchemaName;
    private String existingTableName;
    private String existingColumnName;
    private String newTableSchemaName;
    private String newTableName;
    private String newColumnName;
    private String newColumnDataType;
    private String constraintName;

    public AddLookupTableChange() {
        super("addLookupTable", "Add Lookup Table");
    }

    public String getExistingTableSchemaName() {
        return this.existingTableSchemaName;
    }

    public void setExistingTableSchemaName(String existingTableSchemaName) {
        this.existingTableSchemaName = existingTableSchemaName;
    }

    public String getExistingTableName() {
        return this.existingTableName;
    }

    public void setExistingTableName(String existingTableName) {
        this.existingTableName = existingTableName;
    }

    public String getExistingColumnName() {
        return this.existingColumnName;
    }

    public void setExistingColumnName(String existingColumnName) {
        this.existingColumnName = existingColumnName;
    }

    public String getNewTableSchemaName() {
        return this.newTableSchemaName;
    }

    public void setNewTableSchemaName(String newTableSchemaName) {
        this.newTableSchemaName = newTableSchemaName;
    }

    public String getNewTableName() {
        return this.newTableName;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public String getNewColumnDataType() {
        return this.newColumnDataType;
    }

    public void setNewColumnDataType(String newColumnDataType) {
        this.newColumnDataType = newColumnDataType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getFinalConstraintName() {
        if (this.constraintName == null) {
            return new StringBuffer().append("FK_").append(this.getExistingTableName()).append("_").append(this.getNewTableName()).toString().toUpperCase();
        }
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.existingTableName) == null) {
            throw new InvalidChangeDefinitionException("existingTableName is required", this);
        }
        if (StringUtils.trimToNull(this.existingColumnName) == null) {
            throw new InvalidChangeDefinitionException("existingColumnName is required", this);
        }
        if (StringUtils.trimToNull(this.newTableName) == null) {
            throw new InvalidChangeDefinitionException("newTableName is required", this);
        }
        if (StringUtils.trimToNull(this.newColumnName) == null) {
            throw new InvalidChangeDefinitionException("newColumnName is required", this);
        }
    }

    @Override
    protected Change[] createInverses() {
        DropForeignKeyConstraintChange dropFK = new DropForeignKeyConstraintChange();
        dropFK.setBaseTableSchemaName(this.getExistingTableSchemaName());
        dropFK.setBaseTableName(this.getExistingTableName());
        dropFK.setConstraintName(this.getFinalConstraintName());
        DropTableChange dropTable = new DropTableChange();
        dropTable.setSchemaName(this.getNewTableSchemaName());
        dropTable.setTableName(this.getNewTableName());
        return new Change[]{dropFK, dropTable};
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof DerbyDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table currently not supported in Derby");
        }
        if (database instanceof HsqlDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table currently not supported in HSQLDB");
        }
        if (database instanceof CacheDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table not currently supported for Cache");
        }
        if (database instanceof FirebirdDatabase) {
            throw new UnsupportedChangeException("Add Lookup Table not currently supported for Firebird");
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String newTableSchemaName = this.getNewTableSchemaName() == null ? database.getDefaultSchemaName() : this.getNewTableSchemaName();
        String existingTableSchemaName = this.getExistingTableSchemaName() == null ? database.getDefaultSchemaName() : this.getExistingTableSchemaName();
        SqlStatement[] createTablesSQL = new SqlStatement[]{new RawSqlStatement(new StringBuffer().append("CREATE TABLE ").append(database.escapeTableName(newTableSchemaName, this.getNewTableName())).append(" AS SELECT DISTINCT ").append(this.getExistingColumnName()).append(" AS ").append(this.getNewColumnName()).append(" FROM ").append(database.escapeTableName(existingTableSchemaName, this.getExistingTableName())).append(" WHERE ").append(this.getExistingColumnName()).append(" IS NOT NULL").toString())};
        if (database instanceof MSSQLDatabase) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement(new StringBuffer().append("SELECT DISTINCT ").append(this.getExistingColumnName()).append(" AS ").append(this.getNewColumnName()).append(" INTO ").append(database.escapeTableName(newTableSchemaName, this.getNewTableName())).append(" FROM ").append(database.escapeTableName(existingTableSchemaName, this.getExistingTableName())).append(" WHERE ").append(this.getExistingColumnName()).append(" IS NOT NULL").toString())};
        } else if (database instanceof SybaseASADatabase) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement(new StringBuffer().append("SELECT DISTINCT ").append(this.getExistingColumnName()).append(" AS ").append(this.getNewColumnName()).append(" INTO ").append(database.escapeTableName(newTableSchemaName, this.getNewTableName())).append(" FROM ").append(database.escapeTableName(existingTableSchemaName, this.getExistingTableName())).append(" WHERE ").append(this.getExistingColumnName()).append(" IS NOT NULL").toString())};
        } else if (database instanceof DB2Database) {
            createTablesSQL = new SqlStatement[]{new RawSqlStatement(new StringBuffer().append("CREATE TABLE ").append(database.escapeTableName(newTableSchemaName, this.getNewTableName())).append(" AS (SELECT ").append(this.getExistingColumnName()).append(" AS ").append(this.getNewColumnName()).append(" FROM ").append(database.escapeTableName(existingTableSchemaName, this.getExistingTableName())).append(") WITH NO DATA").toString()), new RawSqlStatement(new StringBuffer().append("INSERT INTO ").append(database.escapeTableName(newTableSchemaName, this.getNewTableName())).append(" SELECT DISTINCT ").append(this.getExistingColumnName()).append(" FROM ").append(database.escapeTableName(existingTableSchemaName, this.getExistingTableName())).append(" WHERE ").append(this.getExistingColumnName()).append(" IS NOT NULL").toString())};
        }
        statements.addAll(Arrays.asList(createTablesSQL));
        if (!(database instanceof OracleDatabase)) {
            AddNotNullConstraintChange addNotNullChange = new AddNotNullConstraintChange();
            addNotNullChange.setSchemaName(newTableSchemaName);
            addNotNullChange.setTableName(this.getNewTableName());
            addNotNullChange.setColumnName(this.getNewColumnName());
            addNotNullChange.setColumnDataType(this.getNewColumnDataType());
            statements.addAll(Arrays.asList(addNotNullChange.generateStatements(database)));
        }
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(newTableSchemaName, this.getNewTableName()));
        }
        AddPrimaryKeyChange addPKChange = new AddPrimaryKeyChange();
        addPKChange.setSchemaName(newTableSchemaName);
        addPKChange.setTableName(this.getNewTableName());
        addPKChange.setColumnNames(this.getNewColumnName());
        statements.addAll(Arrays.asList(addPKChange.generateStatements(database)));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(newTableSchemaName, this.getNewTableName()));
        }
        AddForeignKeyConstraintChange addFKChange = new AddForeignKeyConstraintChange();
        addFKChange.setBaseTableSchemaName(existingTableSchemaName);
        addFKChange.setBaseTableName(this.getExistingTableName());
        addFKChange.setBaseColumnNames(this.getExistingColumnName());
        addFKChange.setReferencedTableSchemaName(newTableSchemaName);
        addFKChange.setReferencedTableName(this.getNewTableName());
        addFKChange.setReferencedColumnNames(this.getNewColumnName());
        addFKChange.setConstraintName(this.getFinalConstraintName());
        statements.addAll(Arrays.asList(addFKChange.generateStatements(database)));
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Lookup table added for ").append(this.getExistingTableName()).append(".").append(this.getExistingColumnName()).toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getExistingTableSchemaName() != null) {
            node.setAttribute("newTableSchemaName", this.getExistingTableSchemaName());
        }
        node.setAttribute("existingTableName", this.getExistingTableName());
        node.setAttribute("existingColumnName", this.getExistingColumnName());
        if (this.getNewTableSchemaName() != null) {
            node.setAttribute("newTableSchemaName", this.getNewTableSchemaName());
        }
        node.setAttribute("newTableName", this.getNewTableName());
        node.setAttribute("newColumnName", this.getNewColumnName());
        node.setAttribute("constraintName", this.getConstraintName());
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table existingTable = new Table(this.getExistingTableName());
        returnSet.add(existingTable);
        Column existingColumn = new Column();
        existingColumn.setTable(existingTable);
        existingColumn.setName(this.getExistingColumnName());
        returnSet.add(existingColumn);
        Table newTable = new Table(this.getNewTableName());
        returnSet.add(newTable);
        Column newColumn = new Column();
        newColumn.setTable(existingTable);
        newColumn.setName(this.getNewColumnName());
        returnSet.add(newColumn);
        ForeignKey fk = new ForeignKey();
        fk.setForeignKeyTable(existingTable);
        fk.setForeignKeyColumns(existingColumn.getName());
        fk.setPrimaryKeyTable(newTable);
        fk.setPrimaryKeyColumns(newColumn.getName());
        returnSet.add(fk);
        return returnSet;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

