/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class InsertStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private Map<String, Object> newColumnValues = new HashMap<String, Object>();

    public InsertStatement(String schemaName, String tableName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public InsertStatement addColumnValue(String columnName, Object newValue) {
        this.newColumnValues.put(columnName, newValue);
        return this;
    }

    public Object getColumnValue(String columnName) {
        return this.newColumnValues.get(columnName);
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        String column;
        if (this.getSchemaName() != null && !database.supportsSchemas()) {
            throw new StatementNotSupportedOnDatabaseException("Database does not support schemas", this, database);
        }
        StringBuffer sql = new StringBuffer("INSERT INTO " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " (");
        Iterator<String> i$ = this.newColumnValues.keySet().iterator();
        while (i$.hasNext()) {
            column = i$.next();
            sql.append(database.escapeColumnName(this.getSchemaName(), this.getTableName(), column)).append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append(") VALUES (");
        i$ = this.newColumnValues.keySet().iterator();
        while (i$.hasNext()) {
            column = i$.next();
            Object newValue = this.newColumnValues.get(column);
            if (newValue == null || newValue.toString().equals("NULL")) {
                sql.append("NULL");
            } else if (newValue instanceof String && database.shouldQuoteValue((String)newValue)) {
                sql.append("'").append(database.escapeStringForDatabase((String)newValue)).append("'");
            } else if (newValue instanceof Date) {
                sql.append(database.getDateLiteral((Date)newValue));
            } else if (newValue instanceof Boolean) {
                if (((Boolean)newValue).booleanValue()) {
                    sql.append(database.getTrueBooleanValue());
                } else {
                    sql.append(database.getFalseBooleanValue());
                }
            } else {
                sql.append(newValue);
            }
            sql.append(", ");
        }
        sql.deleteCharAt(sql.lastIndexOf(" "));
        sql.deleteCharAt(sql.lastIndexOf(","));
        sql.append(")");
        return sql.toString();
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return true;
    }
}

