/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropUniqueConstraintStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String constraintName;
    private String uniqueColumns;

    public DropUniqueConstraintStatement(String schemaName, String tableName, String constraintName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.constraintName = constraintName;
    }

    public DropUniqueConstraintStatement(String schemaName, String tableName, String constraintName, String uniqueColumns) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.constraintName = constraintName;
        this.uniqueColumns = uniqueColumns;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MySQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP KEY " + database.escapeConstraintName(this.getConstraintName());
        }
        if (database instanceof MaxDBDatabase) {
            return "DROP INDEX " + database.escapeConstraintName(this.getConstraintName()) + " ON " + database.escapeTableName(this.getSchemaName(), this.getTableName());
        }
        if (database instanceof OracleDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName()) + " DROP INDEX";
        }
        if (database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP UNIQUE (" + this.getUniqueColumns() + ")";
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }

    public String getUniqueColumns() {
        return this.uniqueColumns;
    }

    public void setUniqueColumns(String uniqueColumns) {
        this.uniqueColumns = uniqueColumns;
    }
}

