/*
 * Decompiled with CFR 0.152.
 */
package liquibase.dbdoc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.Table;
import liquibase.dbdoc.HTMLWriter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableWriter
extends HTMLWriter {
    public TableWriter(File rootOutputDir, Database database) {
        super(new File(rootOutputDir, "tables"), database);
    }

    @Override
    protected String createTitle(Object object) {
        return new StringBuffer().append("Changes affecting table \"").append(object.toString()).append("\"").toString();
    }

    @Override
    protected void writeCustomHTML(FileWriter fileWriter, Object object, List<Change> changes, Database database) throws IOException {
        this.writeColumns(fileWriter, (Table)object, database);
    }

    private void writeColumns(FileWriter fileWriter, Table table, Database database) throws IOException {
        ArrayList<List<String>> cells = new ArrayList<List<String>>();
        for (Column column : table.getColumns()) {
            cells.add(Arrays.asList(column.getDataTypeString(database), new StringBuffer().append("<A HREF=\"../columns/").append(table.getName()).append(".").append(column.getName()).append(".html").append("\">").append(column.getName()).append("</A>").toString()));
        }
        this.writeTable("Current Columns", cells, fileWriter);
    }
}

