/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.LastModified;
import org.springframework.web.servlet.support.WebContentGenerator;
import org.springframework.web.util.UrlPathHelper;

public class WebContentInterceptor
extends WebContentGenerator
implements HandlerInterceptor {
    private UrlPathHelper urlPathHelper = new UrlPathHelper();
    private Map<String, Integer> cacheMappings = new HashMap<String, Integer>();
    private PathMatcher pathMatcher = new AntPathMatcher();

    public WebContentInterceptor() {
        super(false);
    }

    public void setAlwaysUseFullPath(boolean alwaysUseFullPath) {
        this.urlPathHelper.setAlwaysUseFullPath(alwaysUseFullPath);
    }

    public void setUrlDecode(boolean urlDecode) {
        this.urlPathHelper.setUrlDecode(urlDecode);
    }

    public void setUrlPathHelper(UrlPathHelper urlPathHelper) {
        Assert.notNull((Object)urlPathHelper, (String)"UrlPathHelper must not be null");
        this.urlPathHelper = urlPathHelper;
    }

    public void setCacheMappings(Properties cacheMappings) {
        this.cacheMappings.clear();
        Enumeration<?> propNames = cacheMappings.propertyNames();
        while (propNames.hasMoreElements()) {
            String path = (String)propNames.nextElement();
            this.cacheMappings.put(path, Integer.valueOf(cacheMappings.getProperty(path)));
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        this.pathMatcher = pathMatcher;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        Integer cacheSeconds;
        String lookupPath = this.urlPathHelper.getLookupPathForRequest(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up cache seconds for [" + lookupPath + "]"));
        }
        if ((cacheSeconds = this.lookupCacheSeconds(lookupPath)) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying " + cacheSeconds + " cache seconds to [" + lookupPath + "]"));
            }
            this.checkAndPrepare(request, response, cacheSeconds, handler instanceof LastModified);
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Applying default cache seconds to [" + lookupPath + "]"));
            }
            this.checkAndPrepare(request, response, handler instanceof LastModified);
        }
        return true;
    }

    protected Integer lookupCacheSeconds(String urlPath) {
        Integer cacheSeconds = this.cacheMappings.get(urlPath);
        if (cacheSeconds == null) {
            for (String registeredPath : this.cacheMappings.keySet()) {
                if (!this.pathMatcher.match(registeredPath, urlPath)) continue;
                cacheSeconds = this.cacheMappings.get(registeredPath);
            }
        }
        return cacheSeconds;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

