/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.DB2iDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.H2Database;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.SybaseDatabase;
import liquibase.database.UnsupportedDatabase;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseFactory {
    private static DatabaseFactory instance = new DatabaseFactory();
    private static final Logger log = LogFactory.getLogger();
    private List<Database> implementedDatabases = new ArrayList<Database>(Arrays.asList(new OracleDatabase(), new PostgresDatabase(), new MSSQLDatabase(), new MySQLDatabase(), new DerbyDatabase(), new HsqlDatabase(), new DB2Database(), new DB2iDatabase(), new SybaseDatabase(), new H2Database(), new CacheDatabase(), new FirebirdDatabase(), new MaxDBDatabase(), new SQLiteDatabase(), new SybaseASADatabase()));

    private DatabaseFactory() {
    }

    public static DatabaseFactory getInstance() {
        return instance;
    }

    public List<Database> getImplementedDatabases() {
        return this.implementedDatabases;
    }

    public void addDatabaseImplementation(Database database) {
        this.implementedDatabases.add(0, database);
    }

    public Database findCorrectDatabaseImplementation(Connection connection) throws JDBCException {
        Database returnDatabase;
        Object database = null;
        boolean foundImplementation = false;
        for (Database implementedDatabase : this.getImplementedDatabases()) {
            database = implementedDatabase;
            if (!database.isCorrectDatabaseImplementation(connection)) continue;
            foundImplementation = true;
            break;
        }
        if (!foundImplementation) {
            try {
                log.warning(new StringBuffer().append("Unknown database: ").append(connection.getMetaData().getDatabaseProductName()).toString());
            }
            catch (SQLException e) {
                throw new JDBCException(e);
            }
            database = new UnsupportedDatabase();
        }
        try {
            returnDatabase = (Database)database.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        returnDatabase.setConnection(connection);
        return returnDatabase;
    }

    public Database findCorrectDatabaseImplementation(DatabaseConnection connection) throws JDBCException {
        return this.findCorrectDatabaseImplementation(connection.getUnderlyingConnection());
    }

    public String findDefaultDriver(String url) {
        for (Database database : this.getImplementedDatabases()) {
            String defaultDriver = database.getDefaultDriver(url);
            if (defaultDriver == null) continue;
            return defaultDriver;
        }
        return null;
    }
}

