/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.structure.Column;
import liquibase.database.structure.SqlDatabaseSnapshot;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseSnapshot
extends SqlDatabaseSnapshot {
    public OracleDatabaseSnapshot() {
    }

    public OracleDatabaseSnapshot(Database database) throws JDBCException {
        super(database);
    }

    public OracleDatabaseSnapshot(Database database, String schema) throws JDBCException {
        super(database, schema);
    }

    public OracleDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        super(database, statusListeners);
    }

    public OracleDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        super(database, statusListeners, requestedSchema);
    }

    @Override
    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, JDBCException {
        super.getColumnTypeAndDefValue(columnInfo, rs, database);
        String columnTypeName = rs.getString("TYPE_NAME");
        if ("VARCHAR2".equals(columnTypeName)) {
            int charOctetLength = rs.getInt("CHAR_OCTET_LENGTH");
            int columnSize = rs.getInt("COLUMN_SIZE");
            if (columnSize == charOctetLength) {
                columnInfo.setLengthSemantics(Column.LengthSemantics.BYTE);
            } else {
                columnInfo.setLengthSemantics(Column.LengthSemantics.CHAR);
            }
        }
    }
}

