/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimaryKey
implements DatabaseObject,
Comparable<PrimaryKey> {
    private String name;
    private List<String> columnNames = new ArrayList<String>();
    private Table table;
    private boolean certainName = true;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getColumnNames() {
        return StringUtils.join(this.columnNames, ", ");
    }

    public void addColumnName(int position, String columnName) {
        if (position >= this.columnNames.size()) {
            for (int i = this.columnNames.size() - 1; i < position; ++i) {
                this.columnNames.add(null);
            }
        }
        this.columnNames.set(position, columnName);
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    public int compareTo(PrimaryKey o) {
        int returnValue = this.getTable().getName().compareTo(o.getTable().getName());
        if (returnValue == 0) {
            returnValue = this.getColumnNames().compareTo(o.getColumnNames());
        }
        return returnValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimaryKey that = (PrimaryKey)o;
        return !(this.getColumnNames() == null ? that.getColumnNames() != null : !this.getColumnNames().equalsIgnoreCase(that.getColumnNames())) && !(this.getTable().getName() == null ? that.getTable().getName() != null : !this.getTable().getName().equalsIgnoreCase(that.getTable().getName()));
    }

    public int hashCode() {
        int result = this.getColumnNames() != null ? this.getColumnNames().toUpperCase().hashCode() : 0;
        result = 31 * result + (this.table.getName() != null ? this.table.getName().toUpperCase().hashCode() : 0);
        return result;
    }

    public String toString() {
        return new StringBuffer().append(this.getName()).append(" on ").append(this.getTable().getName()).append("(").append(this.getColumnNames()).append(")").toString();
    }

    public List<String> getColumnNamesAsList() {
        return this.columnNames;
    }

    public boolean isCertainName() {
        return this.certainName;
    }

    public void setCertainName(boolean certainName) {
        this.certainName = certainName;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((PrimaryKey)x0);
    }
}

