/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DropViewChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.CreateViewStatement;
import liquibase.database.sql.DropViewStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.View;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;
    private String selectQuery;
    private Boolean replaceIfExists;

    public CreateViewChange() {
        super("createView", "Create View");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getSelectQuery() {
        return this.selectQuery;
    }

    public void setSelectQuery(String selectQuery) {
        this.selectQuery = selectQuery;
    }

    public Boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public void setReplaceIfExists(Boolean replaceIfExists) {
        this.replaceIfExists = replaceIfExists;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.viewName) == null) {
            throw new InvalidChangeDefinitionException("viewName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        boolean replaceIfExists = false;
        if (this.getReplaceIfExists() != null && this.getReplaceIfExists().booleanValue()) {
            replaceIfExists = true;
        }
        if (!this.supportsReplaceIfExistsOption(database) && replaceIfExists) {
            statements.add(new DropViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName()));
            statements.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), false));
        } else {
            statements.add(new CreateViewStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getViewName(), this.getSelectQuery(), replaceIfExists));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("View ").append(this.getViewName()).append(" created").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement("createView");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("viewName", this.getViewName());
        element.appendChild(currentChangeLogFileDOM.createCDATASection(this.getSelectQuery()));
        return element;
    }

    @Override
    protected Change[] createInverses() {
        DropViewChange inverse = new DropViewChange();
        inverse.setViewName(this.getViewName());
        return new Change[]{inverse};
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        View dbObject = new View();
        dbObject.setName(this.viewName);
        return new HashSet<DatabaseObject>(Arrays.asList(dbObject));
    }

    private boolean supportsReplaceIfExistsOption(Database database) {
        return !(database instanceof SQLiteDatabase);
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

