/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropForeignKeyConstraintStatement
implements SqlStatement {
    private String baseTableSchemaName;
    private String baseTableName;
    private String constraintName;

    public DropForeignKeyConstraintStatement(String baseTableSchemaName, String baseTableName, String constraintName) {
        this.baseTableSchemaName = baseTableSchemaName;
        this.baseTableName = baseTableName;
        this.constraintName = constraintName;
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException("SQLite database does not support a drop foreign key statement", this, database);
        }
        if (this.getBaseTableSchemaName() != null && !database.supportsSchemas()) {
            throw new StatementNotSupportedOnDatabaseException("Database does not support schemas", this, database);
        }
        if (database instanceof MySQLDatabase || database instanceof MaxDBDatabase || database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getBaseTableSchemaName(), this.getBaseTableName()) + " DROP FOREIGN KEY " + database.escapeConstraintName(this.getConstraintName());
        }
        return "ALTER TABLE " + database.escapeTableName(this.getBaseTableSchemaName(), this.getBaseTableName()) + " DROP CONSTRAINT " + database.escapeConstraintName(this.getConstraintName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

