/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.namedparam;

import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public abstract class AbstractSqlParameterSource
implements SqlParameterSource {
    private final Map sqlTypes = new HashMap();
    private final Map typeNames = new HashMap();

    public void registerSqlType(String paramName, int sqlType) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        this.sqlTypes.put(paramName, new Integer(sqlType));
    }

    public void registerTypeName(String paramName, String typeName) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        this.typeNames.put(paramName, typeName);
    }

    public int getSqlType(String paramName) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        Integer sqlType = (Integer)this.sqlTypes.get(paramName);
        if (sqlType != null) {
            return sqlType;
        }
        return Integer.MIN_VALUE;
    }

    public String getTypeName(String paramName) {
        Assert.notNull((Object)paramName, (String)"Parameter name must not be null");
        return (String)this.typeNames.get(paramName);
    }
}

