/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropNotNullConstraintChange;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.ReorganizeTableStatement;
import liquibase.database.sql.SetNullableStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddNotNullConstraintChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnName;
    private String defaultNullValue;
    private String columnDataType;

    public AddNotNullConstraintChange() {
        super("addNotNullConstraint", "Add Not-Null Constraint");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public String getDefaultNullValue() {
        return this.defaultNullValue;
    }

    public void setDefaultNullValue(String defaultNullValue) {
        this.defaultNullValue = defaultNullValue;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnName) == null) {
            throw new InvalidChangeDefinitionException("columnName is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String schemaName;
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String string = schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        if (this.defaultNullValue != null) {
            statements.add(new UpdateStatement(schemaName, this.getTableName()).addNewColumnValue(this.getColumnName(), this.getDefaultNullValue()).setWhereClause(new StringBuffer().append(this.getColumnName()).append(" IS NULL").toString()));
        }
        statements.add(new SetNullableStatement(schemaName, this.getTableName(), this.getColumnName(), this.getColumnDataType(), false));
        if (database instanceof DB2Database) {
            statements.add(new ReorganizeTableStatement(schemaName, this.getTableName()));
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        String schemaName;
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        String string = schemaName = this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName();
        if (this.defaultNullValue != null) {
            statements.add(new UpdateStatement(schemaName, this.getTableName()).addNewColumnValue(this.getColumnName(), this.getDefaultNullValue()).setWhereClause(new StringBuffer().append(this.getColumnName()).append(" IS NULL").toString()));
        }
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                if (column.getName().equals(AddNotNullConstraintChange.this.getColumnName())) {
                    column.getConstraints().setNullable(false);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    protected Change[] createInverses() {
        DropNotNullConstraintChange inverse = new DropNotNullConstraintChange();
        inverse.setColumnName(this.getColumnName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setColumnDataType(this.getColumnDataType());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Null constraint has been added to ").append(this.getTableName()).append(".").append(this.getColumnName()).toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement("addNotNullConstraint");
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnName", this.getColumnName());
        if (this.getColumnDataType() != null) {
            element.setAttribute("columnDataType", this.getColumnDataType());
        }
        element.setAttribute("defaultNullValue", this.getDefaultNullValue());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Table table = new Table(this.getTableName());
        Column column = new Column();
        column.setTable(table);
        column.setName(this.getColumnName());
        return new HashSet<Comparable>(Arrays.asList(table, column));
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

