/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.sql.CommentStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.template.JdbcOutputTemplate;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.log.LogFactory;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecuteShellCommandChange
extends AbstractChange {
    private String executable;
    private List<String> os;
    private List<String> args = new ArrayList<String>();

    public ExecuteShellCommandChange() {
        super("executeCommand", "Execute Shell Command");
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public void addArg(String arg) {
        this.args.add(arg);
    }

    public void setOs(String os) {
        this.os = StringUtils.splitAndTrim(os, ",");
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.executable) == null) {
            throw new InvalidChangeDefinitionException("executable is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        String currentOS;
        boolean shouldRun = true;
        if (this.os != null && this.os.size() > 0 && !this.os.contains(currentOS = System.getProperty("os.name"))) {
            shouldRun = false;
            LogFactory.getLogger().info(new StringBuffer().append("Not executing on os ").append(currentOS).append(" when ").append(this.os).append(" was specified").toString());
        }
        boolean nonExecutedMode = false;
        JdbcTemplate jdbcTemplate = database.getJdbcTemplate();
        if (jdbcTemplate instanceof JdbcOutputTemplate) {
            nonExecutedMode = true;
        }
        if (shouldRun && !nonExecutedMode) {
            ArrayList<String> commandArray = new ArrayList<String>();
            commandArray.add(this.executable);
            commandArray.addAll(this.args);
            try {
                ProcessBuilder pb = new ProcessBuilder(commandArray);
                pb.redirectErrorStream(true);
                Process p = pb.start();
                int returnCode = 0;
                try {
                    returnCode = p.waitFor();
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
                ByteArrayOutputStream inputStream = new ByteArrayOutputStream();
                StreamUtil.copy(p.getErrorStream(), errorStream);
                StreamUtil.copy(p.getInputStream(), inputStream);
                LogFactory.getLogger().info(errorStream.toString());
                LogFactory.getLogger().info(inputStream.toString());
                if (returnCode != 0) {
                    throw new RuntimeException(new StringBuffer().append(this.getCommandString()).append(" returned an code of ").append(returnCode).toString());
                }
            }
            catch (IOException e) {
                throw new UnsupportedChangeException(new StringBuffer().append("Error executing command: ").append(e).toString());
            }
        }
        if (nonExecutedMode) {
            return new SqlStatement[]{new CommentStatement(this.getCommandString())};
        }
        return new SqlStatement[0];
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Shell command '").append(this.getCommandString()).append("' executed").toString();
    }

    private String getCommandString() {
        return new StringBuffer().append(this.executable).append(" ").append(StringUtils.join(this.args, " ")).toString();
    }

    @Override
    public Element createNode(Document currentChangeLogDOM) {
        Element root = currentChangeLogDOM.createElement(this.getTagName());
        root.setAttribute("executable", this.getExecutable());
        for (String arg : this.args) {
            Element argElement = currentChangeLogDOM.createElement("arg");
            argElement.setAttribute("value", arg);
            root.appendChild(argElement);
        }
        return root;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        return null;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

