/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AutoIncrementConstraint;
import liquibase.database.sql.ColumnConstraint;
import liquibase.database.sql.ModifyColumnStatement;
import liquibase.database.sql.NotNullConstraint;
import liquibase.database.sql.PrimaryKeyConstraint;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyColumnChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public ModifyColumnChange() {
        super("modifyColumn", "Modify Column");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public void removeColumn(ColumnConfig column) {
        this.columns.remove(column);
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig column : this.columns) {
            if (StringUtils.trimToNull(column.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        ArrayList<ModifyColumnStatement> sql = new ArrayList<ModifyColumnStatement>();
        for (ColumnConfig aColumn : this.columns) {
            HashSet<ColumnConstraint> constraints = new HashSet<ColumnConstraint>();
            if (aColumn.getConstraints() != null) {
                if (aColumn.getConstraints().isNullable() != null && !aColumn.getConstraints().isNullable().booleanValue()) {
                    constraints.add(new NotNullConstraint());
                }
                if (aColumn.getConstraints().isPrimaryKey() != null && aColumn.getConstraints().isPrimaryKey().booleanValue()) {
                    constraints.add(new PrimaryKeyConstraint(aColumn.getConstraints().getPrimaryKeyName()));
                }
            }
            if (aColumn.isAutoIncrement() != null && aColumn.isAutoIncrement().booleanValue()) {
                constraints.add(new AutoIncrementConstraint(aColumn.getName()));
            }
            ModifyColumnStatement modColumnStatement = new ModifyColumnStatement(this.schemaName, this.getTableName(), aColumn.getName(), aColumn.getType(), aColumn.getDefaultValueObject(), constraints.toArray(new ColumnConstraint[constraints.size()]));
            sql.add(modColumnStatement);
        }
        return sql.toArray(new SqlStatement[sql.size()]);
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                Iterator i$ = ModifyColumnChange.this.columns.iterator();
                while (i$.hasNext()) {
                    ColumnConfig cur_column = (ColumnConfig)i$.next();
                    if (!cur_column.getName().equals(column.getName())) continue;
                    column.setType(cur_column.getType());
                    break;
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            System.err.println(e);
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        ArrayList<String> names = new ArrayList<String>(this.columns.size());
        for (ColumnConfig col : this.columns) {
            names.add(new StringBuffer().append(col.getName()).append("(").append(col.getType()).append(")").toString());
        }
        return new StringBuffer().append("Columns ").append(StringUtils.join(names, ",")).append(" of ").append(this.getTableName()).append(" modified").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element node = currentChangeLogFileDOM.createElement("modifyColumn");
        if (this.getSchemaName() != null) {
            node.setAttribute("schemaName", this.getSchemaName());
        }
        node.setAttribute("tableName", this.getTableName());
        for (ColumnConfig col : this.getColumns()) {
            Element subNode = col.createNode(currentChangeLogFileDOM);
            node.appendChild(subNode);
        }
        return node;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        ArrayList<Column> result = new ArrayList<Column>(this.columns.size());
        Table table = new Table(this.getTableName());
        for (ColumnConfig aColumn : this.columns) {
            Column each = new Column();
            each.setTable(table);
            each.setName(aColumn.getName());
            result.add(each);
        }
        return new HashSet<DatabaseObject>(result);
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

