/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.util.Arrays;
import java.util.List;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.PostgresDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Table;
import liquibase.database.structure.View;
import liquibase.log.LogFactory;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang.Enum_;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Integer;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._String;
import liquibase.util.SqlUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Column
implements DatabaseObject,
Comparable<Column> {
    private Table table;
    private View view;
    private String name;
    private int dataType;
    private int columnSize;
    private int decimalDigits;
    private LengthSemantics lengthSemantics;
    private Boolean nullable;
    private String typeName;
    private Object defaultValue;
    private boolean autoIncrement = false;
    private boolean primaryKey = false;
    private boolean unique = false;
    private boolean certainDataType = true;
    private String remarks;

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = view;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int dataType) {
        this.dataType = dataType;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public void setColumnSize(int columnSize) {
        this.columnSize = columnSize;
    }

    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setDecimalDigits(int decimalDigits) {
        this.decimalDigits = decimalDigits;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String toString() {
        String tableOrViewName = this.table == null ? this.view.getName() : this.table.getName();
        return new StringBuffer().append(tableOrViewName).append(".").append(this.getName()).toString();
    }

    @Override
    public int compareTo(Column o) {
        try {
            int returnValue = 0;
            if (this.getTable() != null && o.getTable() == null) {
                return 1;
            }
            if (this.getTable() == null && o.getTable() != null) {
                return -1;
            }
            returnValue = this.getTable() == null && o.getTable() == null ? this.getView().compareTo(o.getView()) : this.getTable().compareTo(o.getTable());
            if (returnValue == 0) {
                returnValue = this.getName().compareTo(o.getName());
            }
            return returnValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        try {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            return this.name.equalsIgnoreCase(column.name) && !(this.table == null ? column.table != null : !this.table.equals(column.table)) && !(this.view == null ? column.view != null : !this.view.equals(column.view));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        try {
            int result = this.table != null ? this.table.hashCode() : 0;
            result = 31 * result + (this.view != null ? this.view.hashCode() : 0);
            result = 31 * result + this.name.toUpperCase().hashCode();
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getDataTypeString(Database database) {
        String dataType;
        List<Integer> noParens = Arrays.asList(_Integer.valueOf(2003), _Integer.valueOf(-5), _Integer.valueOf(-2), _Integer.valueOf(-7), _Integer.valueOf(2004), _Integer.valueOf(16), _Integer.valueOf(2005), _Integer.valueOf(70), _Integer.valueOf(91), _Integer.valueOf(2001), _Integer.valueOf(4), _Integer.valueOf(2000), _Integer.valueOf(-4), _Integer.valueOf(0), _Integer.valueOf(1111), _Integer.valueOf(2006), _Integer.valueOf(5), _Integer.valueOf(2002), _Integer.valueOf(92), _Integer.valueOf(93), _Integer.valueOf(-6), _Integer.valueOf(-1));
        List<Integer> oneParam = Arrays.asList(_Integer.valueOf(1), _Integer.valueOf(12), _Integer.valueOf(-9), _Integer.valueOf(-3), _Integer.valueOf(8), _Integer.valueOf(6));
        List<Integer> twoParams = Arrays.asList(_Integer.valueOf(3), _Integer.valueOf(2), _Integer.valueOf(7));
        String translatedTypeName = this.getTypeName();
        if (database instanceof PostgresDatabase && "bpchar".equals(translatedTypeName)) {
            translatedTypeName = "char";
        }
        if ((database instanceof HsqlDatabase || database instanceof DerbyDatabase) && (this.getDataType() == 6 || this.getDataType() == 8)) {
            return "float";
        }
        if (noParens.contains(_Integer.valueOf(this.getDataType()))) {
            dataType = translatedTypeName;
        } else if (oneParam.contains(_Integer.valueOf(this.getDataType()))) {
            if (database instanceof PostgresDatabase && translatedTypeName.equals("text")) {
                return translatedTypeName;
            }
            if (database instanceof MSSQLDatabase && translatedTypeName.equals("uniqueidentifier")) {
                return translatedTypeName;
            }
            if (database instanceof MySQLDatabase && (translatedTypeName.startsWith("enum(") || translatedTypeName.startsWith("set("))) {
                return translatedTypeName;
            }
            if (database instanceof OracleDatabase && translatedTypeName.equals("VARCHAR2")) {
                return new StringBuffer().append(translatedTypeName).append("(").append(this.getColumnSize()).append(" ").append(this.lengthSemantics).append(")").toString();
            }
            if (database instanceof MySQLDatabase && translatedTypeName.equalsIgnoreCase("DOUBLE")) {
                return translatedTypeName;
            }
            dataType = new StringBuffer().append(translatedTypeName).append("(").append(this.getColumnSize()).append(")").toString();
        } else if (twoParams.contains(_Integer.valueOf(this.getDataType()))) {
            dataType = database instanceof PostgresDatabase && this.getColumnSize() == 131089 ? "DECIMAL" : (database instanceof MSSQLDatabase && _String.contains(translatedTypeName.toLowerCase(), "money") ? translatedTypeName.toUpperCase() : new StringBuffer().append(translatedTypeName).append("(").append(this.getColumnSize()).append(",").append(this.getDecimalDigits()).append(")").toString());
        } else {
            LogFactory.getLogger().warning(new StringBuffer().append("Unknown Data Type: ").append(this.getDataType()).append(" (").append(this.getTypeName()).append(").  Assuming it does not take parameters").toString());
            dataType = this.getTypeName();
        }
        return dataType;
    }

    public boolean isNumeric() {
        return SqlUtil.isNumeric(this.getDataType());
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isDataTypeDifferent(Column otherColumn) {
        if (!this.isCertainDataType() || !otherColumn.isCertainDataType()) {
            return false;
        }
        return this.getDataType() != otherColumn.getDataType() || this.getColumnSize() != otherColumn.getColumnSize() || this.getDecimalDigits() != otherColumn.getDecimalDigits() || this.getLengthSemantics() != otherColumn.getLengthSemantics();
    }

    public boolean isNullabilityDifferent(Column otherColumn) {
        if (this.isNullable() == null && otherColumn.isNullable() == null) {
            return false;
        }
        if (this.isNullable() == null && otherColumn.isNullable() != null) {
            return true;
        }
        if (this.isNullable() != null && otherColumn.isNullable() == null) {
            return true;
        }
        return !this.isNullable().equals(otherColumn.isNullable());
    }

    public boolean isDifferent(Column otherColumn) {
        return this.isDataTypeDifferent(otherColumn) || this.isNullabilityDifferent(otherColumn);
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(boolean primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean isCertainDataType() {
        return this.certainDataType;
    }

    public void setCertainDataType(boolean certainDataType) {
        this.certainDataType = certainDataType;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public LengthSemantics getLengthSemantics() {
        return this.lengthSemantics;
    }

    public void setLengthSemantics(LengthSemantics lengthSemantics) {
        this.lengthSemantics = lengthSemantics;
    }

    @Override
    public /* synthetic */ int compareTo(Object x0) {
        return this.compareTo((Column)x0);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class LengthSemantics
    extends Enum_<LengthSemantics> {
        public static final LengthSemantics CHAR = new LengthSemantics("CHAR", 0);
        public static final LengthSemantics BYTE = new LengthSemantics("BYTE", 1);
        private static final /* synthetic */ LengthSemantics[] $VALUES;
        static /* synthetic */ Class class$liquibase$database$structure$Column$LengthSemantics;

        public static final LengthSemantics[] values() {
            return (LengthSemantics[])$VALUES.clone();
        }

        public static LengthSemantics valueOf(String name) {
            Class<?> clazz = class$liquibase$database$structure$Column$LengthSemantics;
            if (clazz == null) {
                clazz = class$liquibase$database$structure$Column$LengthSemantics = new LengthSemantics[0].getClass().getComponentType();
            }
            return (LengthSemantics)Enum_.valueOf(clazz, name);
        }

        private LengthSemantics() {
            super(var1_1, n);
        }

        static {
            $VALUES = new LengthSemantics[]{CHAR, BYTE};
        }
    }
}

