/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ColumnConfig;
import liquibase.change.DropUniqueConstraintChange;
import liquibase.database.Database;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.AddUniqueConstraintStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.JDBCException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUniqueConstraintChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String columnNames;
    private String constraintName;
    private String tablespace;

    public AddUniqueConstraintChange() {
        super("addUniqueConstraint", "Add Unique Constraint");
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String columnNames) {
        this.columnNames = columnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        if (StringUtils.trimToNull(this.columnNames) == null) {
            throw new InvalidChangeDefinitionException("columnNames is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        AddUniqueConstraintStatement statement = new AddUniqueConstraintStatement(this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.getColumnNames(), this.getConstraintName());
        statement.setTablespace(this.getTablespace());
        return new SqlStatement[]{statement};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) throws UnsupportedChangeException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        SQLiteDatabase.AlterTableVisitor rename_alter_visitor = new SQLiteDatabase.AlterTableVisitor(){

            public ColumnConfig[] getColumnsToAdd() {
                return new ColumnConfig[0];
            }

            public boolean copyThisColumn(ColumnConfig column) {
                return true;
            }

            public boolean createThisColumn(ColumnConfig column) {
                String[] split_columns;
                String[] arr$ = split_columns = AddUniqueConstraintChange.this.getColumnNames().split("[ ]*,[ ]*");
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    String split_column = arr$[i$];
                    if (!column.getName().equals(split_column)) continue;
                    column.getConstraints().setUnique(true);
                }
                return true;
            }

            public boolean createThisIndex(Index index) {
                return true;
            }
        };
        try {
            statements.addAll(SQLiteDatabase.getAlterTableStatements(rename_alter_visitor, database, this.getSchemaName(), this.getTableName()));
        }
        catch (JDBCException e) {
            e.printStackTrace();
        }
        return statements.toArray(new SqlStatement[statements.size()]);
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Unique constraint added to ").append(this.getTableName()).append("(").append(this.getColumnNames()).append(")").toString();
    }

    @Override
    protected Change[] createInverses() {
        DropUniqueConstraintChange inverse = new DropUniqueConstraintChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setConstraintName(this.getConstraintName());
        return new Change[]{inverse};
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement(this.getTagName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        if (this.getTablespace() != null) {
            element.setAttribute("tablespace", this.getTablespace());
        }
        element.setAttribute("tableName", this.getTableName());
        element.setAttribute("columnNames", this.getColumnNames());
        element.setAttribute("constraintName", this.getConstraintName());
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        HashSet<DatabaseObject> returnSet = new HashSet<DatabaseObject>();
        Table table = new Table(this.getTableName());
        returnSet.add(table);
        for (String columnName : this.getColumnNames().split(",")) {
            Column column = new Column();
            column.setTable(table);
            column.setName(columnName.trim());
            returnSet.add(column);
        }
        return returnSet;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

