/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.ColumnConfig;
import liquibase.change.DropIndexChange;
import liquibase.database.Database;
import liquibase.database.sql.CreateIndexStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.InvalidChangeDefinitionException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIndexChange
extends AbstractChange
implements ChangeWithColumns {
    private String schemaName;
    private String tableName;
    private String indexName;
    private Boolean unique;
    private String tablespace;
    private List<ColumnConfig> columns = new ArrayList<ColumnConfig>();

    public CreateIndexChange() {
        super("createIndex", "Create Index");
    }

    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = StringUtils.trimToNull(schemaName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnConfig> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(ColumnConfig column) {
        this.columns.add(column);
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public void validate(Database database) throws InvalidChangeDefinitionException {
        if (StringUtils.trimToNull(this.tableName) == null) {
            throw new InvalidChangeDefinitionException("tableName is required", this);
        }
        for (ColumnConfig column : this.getColumns()) {
            if (StringUtils.trimToNull(column.getName()) != null) continue;
            throw new InvalidChangeDefinitionException("column name is required", this);
        }
    }

    @Override
    public SqlStatement[] generateStatements(Database database) throws UnsupportedChangeException {
        ArrayList<String> columns = new ArrayList<String>();
        for (ColumnConfig column : this.getColumns()) {
            columns.add(column.getName());
        }
        return new SqlStatement[]{new CreateIndexStatement(this.getIndexName(), this.getSchemaName() == null ? database.getDefaultSchemaName() : this.getSchemaName(), this.getTableName(), this.isUnique(), columns.toArray(new String[this.getColumns().size()])).setTablespace(this.getTablespace())};
    }

    @Override
    protected Change[] createInverses() {
        DropIndexChange inverse = new DropIndexChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setIndexName(this.getIndexName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return new StringBuffer().append("Index ").append(this.getIndexName()).append(" created").toString();
    }

    @Override
    public Element createNode(Document currentChangeLogFileDOM) {
        Element element = currentChangeLogFileDOM.createElement("createIndex");
        element.setAttribute("indexName", this.getIndexName());
        if (this.getSchemaName() != null) {
            element.setAttribute("schemaName", this.getSchemaName());
        }
        element.setAttribute("tableName", this.getTableName());
        if (this.unique != null) {
            if (this.unique.booleanValue()) {
                element.setAttribute("unique", "true");
            } else {
                element.setAttribute("unique", "false");
            }
        }
        for (ColumnConfig column : this.getColumns()) {
            Element columnElement = currentChangeLogFileDOM.createElement("column");
            columnElement.setAttribute("name", column.getName());
            element.appendChild(columnElement);
        }
        return element;
    }

    @Override
    public Set<DatabaseObject> getAffectedDatabaseObjects() {
        Index index = new Index();
        index.setTable(new Table(this.tableName));
        index.setName(this.indexName);
        index.setUnique(this.unique);
        Table table = new Table(this.getTableName());
        return new HashSet<Comparable>(Arrays.asList(index, table));
    }

    public void setUnique(Boolean isUnique) {
        this.unique = isUnique;
    }

    public Boolean isUnique() {
        return this.unique;
    }

    @Override
    public /* synthetic */ Node createNode(Document x0) {
        return this.createNode(x0);
    }
}

