/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.structure;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.OracleDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.structure.Column;
import liquibase.database.structure.DatabaseSnapshot;
import liquibase.database.structure.ForeignKey;
import liquibase.database.structure.Index;
import liquibase.database.structure.PrimaryKey;
import liquibase.database.structure.Sequence;
import liquibase.database.structure.Table;
import liquibase.database.structure.UniqueConstraint;
import liquibase.database.structure.View;
import liquibase.database.template.JdbcTemplate;
import liquibase.diff.DiffStatusListener;
import liquibase.exception.JDBCException;
import liquibase.log.LogFactory;
import liquibase.retro.net.sf.retrotranslator.runtime.java.lang._Integer;
import liquibase.util.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlDatabaseSnapshot
implements DatabaseSnapshot {
    protected DatabaseMetaData databaseMetaData;
    protected Database database;
    protected Set<Table> tables = new HashSet<Table>();
    protected Set<View> views = new HashSet<View>();
    protected Set<Column> columns = new HashSet<Column>();
    protected Set<ForeignKey> foreignKeys = new HashSet<ForeignKey>();
    protected Set<UniqueConstraint> uniqueConstraints = new HashSet<UniqueConstraint>();
    protected Set<Index> indexes = new HashSet<Index>();
    protected Set<PrimaryKey> primaryKeys = new HashSet<PrimaryKey>();
    protected Set<Sequence> sequences = new HashSet<Sequence>();
    protected Map<String, Table> tablesMap = new HashMap<String, Table>();
    protected Map<String, View> viewsMap = new HashMap<String, View>();
    protected Map<String, Column> columnsMap = new HashMap<String, Column>();
    private Set<DiffStatusListener> statusListeners;
    protected static final Logger log = LogFactory.getLogger();
    private String schema;
    private boolean hasDatabaseChangeLogTable = false;
    static /* synthetic */ Class class$java$lang$String;

    public SqlDatabaseSnapshot() {
    }

    public SqlDatabaseSnapshot(Database database) throws JDBCException {
        this(database, null, null);
    }

    public SqlDatabaseSnapshot(Database database, String schema) throws JDBCException {
        this(database, null, schema);
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners) throws JDBCException {
        this(database, statusListeners, database.getDefaultSchemaName());
    }

    public SqlDatabaseSnapshot(Database database, Set<DiffStatusListener> statusListeners, String requestedSchema) throws JDBCException {
        if (requestedSchema == null) {
            requestedSchema = database.getDefaultSchemaName();
        }
        try {
            this.schema = requestedSchema;
            this.database = database;
            this.databaseMetaData = database.getConnection().getMetaData();
            this.statusListeners = statusListeners;
            log.finest("Reading table and views ....");
            this.readTablesAndViews(requestedSchema);
            log.finest("Reading foreign keys ....");
            this.readForeignKeyInformation(requestedSchema);
            log.finest("Reading primary keys ....");
            this.readPrimaryKeys(requestedSchema);
            log.finest("Reading columns ....");
            this.readColumns(requestedSchema);
            log.finest("Reading unique constraints ....");
            this.readUniqueConstraints(requestedSchema);
            log.finest("Reading indexes ....");
            this.readIndexes(requestedSchema);
            log.finest("Reading sequences ....");
            this.readSequences(requestedSchema);
            this.tables = new HashSet<Table>(this.tablesMap.values());
            this.views = new HashSet<View>(this.viewsMap.values());
            this.columns = new HashSet<Column>(this.columnsMap.values());
        }
        catch (SQLException e) {
            throw new JDBCException(e);
        }
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public Set<Table> getTables() {
        return this.tables;
    }

    @Override
    public Set<View> getViews() {
        return this.views;
    }

    @Override
    public Column getColumn(Column column) {
        if (column.getTable() == null) {
            return this.getColumn(column.getView().getName(), column.getName());
        }
        return this.getColumn(column.getTable().getName(), column.getName());
    }

    @Override
    public Column getColumn(String tableName, String columnName) {
        String tableAndColumn = new StringBuffer().append(tableName).append(".").append(columnName).toString();
        Column returnColumn = this.columnsMap.get(tableAndColumn);
        if (returnColumn == null) {
            for (String key : this.columnsMap.keySet()) {
                if (!key.equalsIgnoreCase(tableAndColumn)) continue;
                return this.columnsMap.get(key);
            }
        }
        return returnColumn;
    }

    @Override
    public Set<Column> getColumns() {
        return this.columns;
    }

    @Override
    public Set<ForeignKey> getForeignKeys() {
        return this.foreignKeys;
    }

    @Override
    public Set<Index> getIndexes() {
        return this.indexes;
    }

    @Override
    public Set<PrimaryKey> getPrimaryKeys() {
        return this.primaryKeys;
    }

    @Override
    public Set<Sequence> getSequences() {
        return this.sequences;
    }

    @Override
    public Set<UniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    protected void readTablesAndViews(String schema) throws SQLException, JDBCException {
        this.updateListeners(new StringBuffer().append("Reading tables for ").append(this.database.toString()).append(" ...").toString());
        ResultSet rs = this.databaseMetaData.getTables(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, new String[]{"TABLE", "VIEW", "ALIAS"});
        while (rs.next()) {
            String type = rs.getString("TABLE_TYPE");
            String name = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
            String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
            String catalogName = this.convertFromDatabaseName(rs.getString("TABLE_CAT"));
            String remarks = rs.getString("REMARKS");
            if (this.database.isSystemTable(catalogName, schemaName, name) || this.database.isLiquibaseTable(name) || this.database.isSystemView(catalogName, schemaName, name)) {
                if (!name.equalsIgnoreCase(this.database.getDatabaseChangeLogTableName())) continue;
                this.hasDatabaseChangeLogTable = true;
                continue;
            }
            if ("TABLE".equals(type) || "ALIAS".equals(type)) {
                Table table = new Table(name);
                table.setRemarks(StringUtils.trimToNull(remarks));
                table.setDatabase(this.database);
                table.setSchema(schemaName);
                this.tablesMap.put(name, table);
                continue;
            }
            if (!"VIEW".equals(type)) continue;
            View view = new View();
            view.setName(name);
            view.setSchema(schemaName);
            try {
                view.setDefinition(this.database.getViewDefinition(schema, name));
            }
            catch (JDBCException e) {
                System.out.println(new StringBuffer().append("Error getting ").append(this.database.getConnectionURL()).append(" view with ").append(((AbstractDatabase)this.database).getViewDefinitionSql(schema, name)).toString());
                throw e;
            }
            this.viewsMap.put(name, view);
        }
        rs.close();
    }

    protected String convertFromDatabaseName(String objectName) {
        if (objectName == null) {
            return null;
        }
        return objectName;
    }

    protected void readColumns(String schema) throws SQLException, JDBCException {
        this.updateListeners(new StringBuffer().append("Reading columns for ").append(this.database.toString()).append(" ...").toString());
        Statement selectStatement = this.database.getConnection().createStatement();
        ResultSet rs = this.databaseMetaData.getColumns(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), null, null);
        while (rs.next()) {
            Column columnInfo = new Column();
            String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
            String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
            String schemaName = this.convertFromDatabaseName(rs.getString("TABLE_SCHEM"));
            String catalogName = this.convertFromDatabaseName(rs.getString("TABLE_CAT"));
            String remarks = rs.getString("REMARKS");
            if (this.database.isSystemTable(catalogName, schemaName, tableName) || this.database.isLiquibaseTable(tableName)) continue;
            Table table = this.tablesMap.get(tableName);
            if (table == null) {
                View view = this.viewsMap.get(tableName);
                if (view == null) {
                    log.info(new StringBuffer().append("Could not find table or view ").append(tableName).append(" for column ").append(columnName).toString());
                    continue;
                }
                columnInfo.setView(view);
                columnInfo.setAutoIncrement(false);
                view.getColumns().add(columnInfo);
            } else {
                columnInfo.setTable(table);
                columnInfo.setAutoIncrement(this.database.isColumnAutoIncrement(schema, tableName, columnName));
                table.getColumns().add(columnInfo);
            }
            columnInfo.setName(columnName);
            columnInfo.setDataType(rs.getInt("DATA_TYPE"));
            columnInfo.setColumnSize(rs.getInt("COLUMN_SIZE"));
            columnInfo.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
            int nullable = rs.getInt("NULLABLE");
            if (nullable == 0) {
                columnInfo.setNullable(false);
            } else if (nullable == 1) {
                columnInfo.setNullable(true);
            }
            columnInfo.setPrimaryKey(this.isPrimaryKey(columnInfo));
            this.getColumnTypeAndDefValue(columnInfo, rs, this.database);
            columnInfo.setRemarks(remarks);
            this.columnsMap.put(new StringBuffer().append(tableName).append(".").append(columnName).toString(), columnInfo);
        }
        rs.close();
        selectStatement.close();
    }

    protected void getColumnTypeAndDefValue(Column columnInfo, ResultSet rs, Database database) throws SQLException, JDBCException {
        Object defaultValue = rs.getObject("COLUMN_DEF");
        try {
            columnInfo.setDefaultValue(database.convertDatabaseValueToJavaObject(defaultValue, columnInfo.getDataType(), columnInfo.getColumnSize(), columnInfo.getDecimalDigits()));
        }
        catch (ParseException e) {
            throw new JDBCException(e);
        }
        columnInfo.setTypeName(database.getColumnType(rs.getString("TYPE_NAME"), columnInfo.isAutoIncrement()));
    }

    protected boolean isPrimaryKey(Column columnInfo) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (columnInfo.getTable() == null || !pk.getTable().getName().equalsIgnoreCase(columnInfo.getTable().getName()) || !pk.getColumnNamesAsList().contains(columnInfo.getName())) continue;
            return true;
        }
        return false;
    }

    protected void readForeignKeyInformation(String schema) throws JDBCException, SQLException {
        this.updateListeners(new StringBuffer().append("Reading foreign keys for ").append(this.database.toString()).append(" ...").toString());
        for (Table table : this.tablesMap.values()) {
            String dbCatalog = this.database.convertRequestedSchemaToCatalog(schema);
            String dbSchema = this.database.convertRequestedSchemaToSchema(schema);
            ResultSet rs = this.databaseMetaData.getExportedKeys(dbCatalog, dbSchema, table.getName());
            ForeignKey fkInfo = null;
            while (rs.next()) {
                String fkName = this.convertFromDatabaseName(rs.getString("FK_NAME"));
                String pkTableName = this.convertFromDatabaseName(rs.getString("PKTABLE_NAME"));
                String pkColumn = this.convertFromDatabaseName(rs.getString("PKCOLUMN_NAME"));
                Table pkTable = this.tablesMap.get(pkTableName);
                if (pkTable == null) {
                    log.warning(new StringBuffer().append("Foreign key ").append(fkName).append(" references table ").append(pkTableName).append(", which we cannot find.  Ignoring.").toString());
                    continue;
                }
                int keySeq = rs.getInt("KEY_SEQ");
                if (fkInfo == null || fkInfo != null && !fkInfo.getPrimaryKeyTable().getName().equals(pkTableName)) {
                    fkInfo = new ForeignKey();
                }
                fkInfo.setPrimaryKeyTable(pkTable);
                fkInfo.addPrimaryKeyColumn(pkColumn);
                String fkTableName = this.convertFromDatabaseName(rs.getString("FKTABLE_NAME"));
                String fkSchema = this.convertFromDatabaseName(rs.getString("FKTABLE_SCHEM"));
                String fkColumn = this.convertFromDatabaseName(rs.getString("FKCOLUMN_NAME"));
                Table fkTable = this.tablesMap.get(fkTableName);
                if (fkTable == null) {
                    fkTable = new Table(fkTableName);
                    fkTable.setDatabase(this.database);
                    fkTable.setSchema(fkSchema);
                    log.warning(new StringBuffer().append("Foreign key ").append(fkName).append(" is in table ").append(fkTableName).append(", which is in a different schema.  Retaining FK in diff, but table will not be diffed.").toString());
                }
                fkInfo.setForeignKeyTable(fkTable);
                fkInfo.addForeignKeyColumn(fkColumn);
                fkInfo.setName(fkName);
                Integer updateRule = _Integer.valueOf(rs.getInt("UPDATE_RULE"));
                if (rs.wasNull()) {
                    updateRule = null;
                }
                Integer deleteRule = _Integer.valueOf(rs.getInt("DELETE_RULE"));
                if (rs.wasNull()) {
                    deleteRule = null;
                }
                fkInfo.setUpdateRule(updateRule);
                fkInfo.setDeleteRule(deleteRule);
                if (this.database.supportsInitiallyDeferrableColumns()) {
                    short deferrablility = rs.getShort("DEFERRABILITY");
                    if (deferrablility == 5) {
                        fkInfo.setDeferrable(Boolean.TRUE);
                        fkInfo.setInitiallyDeferred(Boolean.TRUE);
                    } else if (deferrablility == 6) {
                        fkInfo.setDeferrable(Boolean.TRUE);
                        fkInfo.setInitiallyDeferred(Boolean.FALSE);
                    } else if (deferrablility == 7) {
                        fkInfo.setDeferrable(Boolean.FALSE);
                        fkInfo.setInitiallyDeferred(Boolean.FALSE);
                    }
                }
                if (keySeq != 1) continue;
                this.foreignKeys.add(fkInfo);
            }
            rs.close();
        }
    }

    protected void readIndexes(String schema) throws JDBCException, SQLException {
        this.updateListeners(new StringBuffer().append("Reading indexes for ").append(this.database.toString()).append(" ...").toString());
        for (Table table : this.tablesMap.values()) {
            ResultSet rs;
            Statement statement = null;
            if (this.database instanceof OracleDatabase) {
                statement = this.database.getConnection().createStatement();
                String sql = new StringBuffer().append("SELECT INDEX_NAME, 3 AS TYPE, TABLE_NAME, COLUMN_NAME, COLUMN_POSITION AS ORDINAL_POSITION, null AS FILTER_CONDITION FROM ALL_IND_COLUMNS WHERE TABLE_OWNER='").append(this.database.convertRequestedSchemaToSchema(schema)).append("' AND TABLE_NAME='").append(table.getName()).append("' ORDER BY INDEX_NAME, ORDINAL_POSITION").toString();
                rs = statement.executeQuery(sql);
            } else {
                rs = this.databaseMetaData.getIndexInfo(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), table.getName(), false, true);
            }
            HashMap<String, Index> indexMap = new HashMap<String, Index>();
            while (rs.next()) {
                Index indexInformation;
                String indexName = this.convertFromDatabaseName(rs.getString("INDEX_NAME"));
                short type = rs.getShort("TYPE");
                boolean nonUnique = true;
                try {
                    nonUnique = rs.getBoolean("NON_UNIQUE");
                }
                catch (SQLException e) {
                    // empty catch block
                }
                String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                short position = rs.getShort("ORDINAL_POSITION");
                String filterCondition = rs.getString("FILTER_CONDITION");
                if (type == 0 || columnName == null) continue;
                if (indexMap.containsKey(indexName)) {
                    indexInformation = (Index)indexMap.get(indexName);
                } else {
                    indexInformation = new Index();
                    indexInformation.setTable(table);
                    indexInformation.setName(indexName);
                    indexInformation.setUnique(!nonUnique);
                    indexInformation.setFilterCondition(filterCondition);
                    indexMap.put(indexName, indexInformation);
                }
                for (int i = indexInformation.getColumns().size(); i < position; ++i) {
                    indexInformation.getColumns().add(null);
                }
                indexInformation.getColumns().set(position - 1, columnName);
            }
            for (Map.Entry entry : indexMap.entrySet()) {
                this.indexes.add((Index)entry.getValue());
            }
            rs.close();
            if (statement == null) continue;
            statement.close();
        }
        HashSet<Index> indexesToRemove = new HashSet<Index>();
        for (Index index : this.indexes) {
            for (PrimaryKey pk : this.primaryKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(pk.getTable().getName()) || !index.getColumnNames().equals(pk.getColumnNames())) continue;
                indexesToRemove.add(index);
            }
            for (ForeignKey fk : this.foreignKeys) {
                if (!index.getTable().getName().equalsIgnoreCase(fk.getForeignKeyTable().getName()) || !index.getColumnNames().equals(fk.getForeignKeyColumns())) continue;
                indexesToRemove.add(index);
            }
            for (UniqueConstraint uc : this.uniqueConstraints) {
                if (!index.getTable().getName().equalsIgnoreCase(uc.getTable().getName()) || !index.getColumnNames().equals(uc.getColumnNames())) continue;
                indexesToRemove.add(index);
            }
        }
        this.indexes.removeAll(indexesToRemove);
    }

    protected void readPrimaryKeys(String schema) throws JDBCException, SQLException {
        this.updateListeners(new StringBuffer().append("Reading primary keys for ").append(this.database.toString()).append(" ...").toString());
        ArrayList<PrimaryKey> foundPKs = new ArrayList<PrimaryKey>();
        for (Table table : this.tablesMap.values()) {
            ResultSet rs = this.databaseMetaData.getPrimaryKeys(this.database.convertRequestedSchemaToCatalog(schema), this.database.convertRequestedSchemaToSchema(schema), table.getName());
            while (rs.next()) {
                String tableName = this.convertFromDatabaseName(rs.getString("TABLE_NAME"));
                String columnName = this.convertFromDatabaseName(rs.getString("COLUMN_NAME"));
                short position = rs.getShort("KEY_SEQ");
                boolean foundExistingPK = false;
                for (PrimaryKey pk : foundPKs) {
                    if (!pk.getTable().getName().equals(tableName)) continue;
                    pk.addColumnName(position - 1, columnName);
                    foundExistingPK = true;
                }
                if (foundExistingPK) continue;
                PrimaryKey primaryKey = new PrimaryKey();
                primaryKey.setTable(table);
                primaryKey.addColumnName(position - 1, columnName);
                primaryKey.setName(this.convertPrimaryKeyName(rs.getString("PK_NAME")));
                foundPKs.add(primaryKey);
            }
            rs.close();
        }
        this.primaryKeys.addAll(foundPKs);
    }

    protected String convertPrimaryKeyName(String pkName) throws SQLException {
        return pkName;
    }

    protected void readUniqueConstraints(String schema) throws JDBCException, SQLException {
        this.updateListeners(new StringBuffer().append("Reading unique constraints for ").append(this.database.toString()).append(" ...").toString());
    }

    protected void readSequences(String schema) throws JDBCException {
        this.updateListeners(new StringBuffer().append("Reading sequences for ").append(this.database.toString()).append(" ...").toString());
        String convertedSchemaName = this.database.convertRequestedSchemaToSchema(schema);
        if (this.database.supportsSequences()) {
            List sequenceNames;
            JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
            SqlStatement sqlStatement = this.database.createFindSequencesSQL(schema);
            Class<?> clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = new String[0].getClass().getComponentType();
            }
            if ((sequenceNames = jdbcTemplate.queryForList(sqlStatement, clazz, new ArrayList<SqlVisitor>())) != null) {
                for (String sequenceName : sequenceNames) {
                    Sequence seq = new Sequence();
                    seq.setName(sequenceName.trim());
                    seq.setSchema(convertedSchemaName);
                    this.sequences.add(seq);
                }
            }
        }
    }

    protected void updateListeners(String message) {
        if (this.statusListeners == null) {
            return;
        }
        log.finest(message);
        for (DiffStatusListener listener : this.statusListeners) {
            listener.statusUpdate(message);
        }
    }

    @Override
    public Table getTable(String tableName) {
        for (Table table : this.getTables()) {
            if (!table.getName().equalsIgnoreCase(tableName)) continue;
            return table;
        }
        return null;
    }

    @Override
    public ForeignKey getForeignKey(String foreignKeyName) {
        for (ForeignKey fk : this.getForeignKeys()) {
            if (!fk.getName().equalsIgnoreCase(foreignKeyName)) continue;
            return fk;
        }
        return null;
    }

    @Override
    public Sequence getSequence(String sequenceName) {
        for (Sequence sequence : this.getSequences()) {
            if (!sequence.getName().equalsIgnoreCase(sequenceName)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public Index getIndex(String indexName) {
        for (Index index : this.getIndexes()) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    @Override
    public View getView(String viewName) {
        for (View view : this.getViews()) {
            if (!view.getName().equalsIgnoreCase(viewName)) continue;
            return view;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKey(String pkName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getName().equalsIgnoreCase(pkName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public PrimaryKey getPrimaryKeyForTable(String tableName) {
        for (PrimaryKey pk : this.getPrimaryKeys()) {
            if (!pk.getTable().getName().equalsIgnoreCase(tableName)) continue;
            return pk;
        }
        return null;
    }

    @Override
    public UniqueConstraint getUniqueConstraint(String ucName) {
        for (UniqueConstraint uc : this.getUniqueConstraints()) {
            if (!uc.getName().equalsIgnoreCase(ucName)) continue;
            return uc;
        }
        return null;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public boolean hasDatabaseChangeLogTable() {
        return this.hasDatabaseChangeLogTable;
    }
}

