/*
 * Decompiled with CFR 0.152.
 */
package liquibase.lock;

import java.net.InetAddress;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.DatabaseChangeLogLock;
import liquibase.database.Database;
import liquibase.database.sql.RawSqlStatement;
import liquibase.database.sql.SqlStatement;
import liquibase.database.sql.UpdateStatement;
import liquibase.database.sql.visitor.SqlVisitor;
import liquibase.database.template.JdbcTemplate;
import liquibase.exception.JDBCException;
import liquibase.exception.LockException;
import liquibase.log.LogFactory;
import liquibase.util.NetUtil;

public class LockHandler {
    private Database database;
    private boolean hasChangeLogLock = false;
    private long changeLogLockWaitTime = 300000L;
    private static Map<Database, LockHandler> instances = new HashMap<Database, LockHandler>();
    static /* synthetic */ Class class$java$lang$Boolean;

    private LockHandler(Database database) {
        this.database = database;
    }

    public static LockHandler getInstance(Database database) {
        if (!instances.containsKey(database)) {
            instances.put(database, new LockHandler(database));
        }
        return instances.get(database);
    }

    public boolean acquireLock() throws LockException {
        try {
            Boolean locked;
            this.database.checkDatabaseChangeLogLockTable();
            try {
                JdbcTemplate jdbcTemplate = this.database.getJdbcTemplate();
                SqlStatement sqlStatement = this.database.getSelectChangeLogLockSQL();
                Class<?> clazz = class$java$lang$Boolean;
                if (clazz == null) {
                    clazz = class$java$lang$Boolean = new Boolean[0].getClass().getComponentType();
                }
                locked = (Boolean)jdbcTemplate.queryForObject(sqlStatement, clazz, new ArrayList<SqlVisitor>());
            }
            catch (JDBCException e) {
                if (!this.database.getJdbcTemplate().executesStatements()) {
                    locked = false;
                }
                throw new LockException("Error checking database lock status", e);
            }
            if (locked.booleanValue()) {
                return false;
            }
            UpdateStatement updateStatement = new UpdateStatement(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
            updateStatement.addNewColumnValue("LOCKED", true);
            updateStatement.addNewColumnValue("LOCKGRANTED", new Timestamp(new Date().getTime()));
            InetAddress localHost = NetUtil.getLocalHost();
            updateStatement.addNewColumnValue("LOCKEDBY", localHost.getHostName() + " (" + localHost.getHostAddress() + ")");
            updateStatement.setWhereClause("ID  = 1");
            this.database.getJdbcTemplate().comment("Lock Database");
            int rowsUpdated = this.database.getJdbcTemplate().update(updateStatement, new ArrayList<SqlVisitor>());
            if (rowsUpdated != 1 && this.database.getJdbcTemplate().executesStatements()) {
                throw new LockException("Did not update change log lock correctly");
            }
            this.database.commit();
            LogFactory.getLogger().info("Successfully acquired change log lock");
            this.hasChangeLogLock = true;
            return true;
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    public void releaseLock() throws LockException {
        try {
            if (this.database.doesChangeLogLockTableExist() || !this.database.getJdbcTemplate().executesStatements()) {
                UpdateStatement releaseStatement = new UpdateStatement(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName());
                releaseStatement.addNewColumnValue("LOCKED", false);
                releaseStatement.addNewColumnValue("LOCKGRANTED", null);
                releaseStatement.addNewColumnValue("LOCKEDBY", null);
                releaseStatement.setWhereClause(" ID = 1");
                this.database.getJdbcTemplate().comment("Release Database Lock");
                int updatedRows = this.database.getJdbcTemplate().update(releaseStatement, new ArrayList<SqlVisitor>());
                if (updatedRows != 1 && this.database.getJdbcTemplate().executesStatements()) {
                    throw new LockException("Did not update change log lock correctly.\n\n" + releaseStatement + " updated " + updatedRows + " instead of the expected 1 row.");
                }
                this.database.commit();
                this.hasChangeLogLock = false;
                instances.remove(this.database);
                LogFactory.getLogger().info("Successfully released change log lock");
            }
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    public DatabaseChangeLogLock[] listLocks() throws LockException {
        try {
            if (!this.database.doesChangeLogLockTableExist()) {
                return new DatabaseChangeLogLock[0];
            }
            ArrayList<DatabaseChangeLogLock> allLocks = new ArrayList<DatabaseChangeLogLock>();
            RawSqlStatement sqlStatement = new RawSqlStatement("SELECT ID, LOCKED, LOCKGRANTED, LOCKEDBY FROM " + this.database.escapeTableName(this.database.getDefaultSchemaName(), this.database.getDatabaseChangeLogLockTableName()));
            List<Map> rows = this.database.getJdbcTemplate().queryForList((SqlStatement)sqlStatement, new ArrayList<SqlVisitor>());
            Iterator<Map> i$ = rows.iterator();
            while (i$.hasNext()) {
                Map columnMap = i$.next();
                Object lockedValue = columnMap.get("LOCKED");
                Boolean locked = lockedValue instanceof Number ? Boolean.valueOf(((Number)lockedValue).intValue() == 1) : (Boolean)lockedValue;
                if (locked == null || !locked.booleanValue()) continue;
                allLocks.add(new DatabaseChangeLogLock(((Number)columnMap.get("ID")).intValue(), (Date)columnMap.get("LOCKGRANTED"), (String)columnMap.get("LOCKEDBY")));
            }
            return allLocks.toArray(new DatabaseChangeLogLock[allLocks.size()]);
        }
        catch (Exception e) {
            throw new LockException(e);
        }
    }

    public void waitForLock() throws LockException {
        block9: {
            if (this.hasChangeLogLock) {
                return;
            }
            try {
                this.database.checkDatabaseChangeLogLockTable();
                boolean locked = false;
                long timeToGiveUp = new Date().getTime() + this.changeLogLockWaitTime;
                while (!locked && new Date().getTime() < timeToGiveUp) {
                    locked = this.acquireLock();
                    if (locked) continue;
                    System.out.println("Waiting for changelog lock....");
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {}
                }
                if (!locked) {
                    String lockedBy;
                    DatabaseChangeLogLock[] locks = this.listLocks();
                    if (locks.length > 0) {
                        DatabaseChangeLogLock lock = locks[0];
                        lockedBy = lock.getLockedBy() + " since " + DateFormat.getDateTimeInstance(3, 3).format(lock.getLockGranted());
                    } else {
                        lockedBy = "UNKNOWN";
                    }
                    throw new LockException("Could not acquire change log lock.  Currently locked by " + lockedBy);
                }
            }
            catch (JDBCException e) {
                if (!this.database.getJdbcTemplate().executesStatements()) break block9;
                throw new LockException(e);
            }
        }
    }

    public void forceReleaseLock() throws LockException, JDBCException {
        this.database.checkDatabaseChangeLogLockTable();
        this.releaseLock();
    }

    public void reset() {
        this.hasChangeLogLock = false;
    }
}

