/*
 * Decompiled with CFR 0.152.
 */
package liquibase.log;

import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class LogFactory {
    public static Logger getLogger() {
        return Logger.getLogger("liquibase");
    }

    public static void setLoggingLevel(String logLevel) {
        if ("all".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.ALL);
        } else if ("finest".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.FINEST);
        } else if ("finer".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.FINER);
        } else if ("fine".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.FINE);
        } else if ("info".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.INFO);
        } else if ("warning".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.WARNING);
        } else if ("severe".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.SEVERE);
        } else if ("off".equalsIgnoreCase(logLevel)) {
            LogFactory.getLogger().setLevel(Level.OFF);
        } else {
            throw new IllegalArgumentException("Unknown log level: " + logLevel);
        }
    }

    public static void setLoggingLevel(String logLevel, String logFile) {
        FileHandler fH;
        try {
            fH = new FileHandler(logFile);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot open log file " + logFile + ". Reason: " + e.getMessage());
        }
        fH.setFormatter(new SimpleFormatter());
        LogFactory.getLogger().addHandler(fH);
        LogFactory.getLogger().setUseParentHandlers(false);
        LogFactory.setLoggingLevel(logLevel);
    }
}

