/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.OracleDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class DropDefaultValueStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnName;

    public DropDefaultValueStatement(String schemaName, String tableName, String columnName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnName = columnName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " DROP CONSTRAINT " + ((MSSQLDatabase)database).generateDefaultConstraintName(this.getTableName(), this.getColumnName());
        }
        if (database instanceof MySQLDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DROP DEFAULT";
        }
        if (database instanceof OracleDatabase || database instanceof SybaseASADatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " MODIFY " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DEFAULT NULL";
        }
        if (database instanceof DerbyDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " WITH DEFAULT NULL";
        }
        if (database instanceof MaxDBDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " DROP DEFAULT";
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN  " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getColumnName()) + " SET DEFAULT NULL";
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

