/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import liquibase.FileOpener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeFileOpener
implements FileOpener {
    List<FileOpener> openers;

    public CompositeFileOpener(List<FileOpener> openers) {
        this.openers = openers;
    }

    public CompositeFileOpener(FileOpener[] openers) {
        this.openers = Arrays.asList(openers);
    }

    @Override
    public InputStream getResourceAsStream(String file) throws IOException {
        for (FileOpener o : this.openers) {
            InputStream is = o.getResourceAsStream(file);
            if (is == null) continue;
            return is;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String packageName) throws IOException {
        for (FileOpener o : this.openers) {
            Enumeration<URL> e = o.getResources(packageName);
            if (!e.hasMoreElements()) continue;
            return e;
        }
        return new Vector().elements();
    }

    @Override
    public ClassLoader toClassLoader() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
        for (FileOpener fo : this.openers) {
            classLoaders.add(fo.toClassLoader());
        }
        return new CompositeClassLoader(classLoaders.toArray(new ClassLoader[classLoaders.size()]));
    }

    private static class CompositeClassLoader
    extends ClassLoader {
        private final List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();

        public CompositeClassLoader(ClassLoader[] classLoaders) {
            this.classLoaders.addAll(Arrays.asList(classLoaders));
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            Iterator<ClassLoader> i$ = this.classLoaders.iterator();
            while (i$.hasNext()) {
                ClassLoader classLoader1;
                ClassLoader classLoader = classLoader1 = i$.next();
                try {
                    return classLoader.loadClass(name);
                }
                catch (ClassNotFoundException notFound) {
                }
            }
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
            throw new ClassNotFoundException(name);
        }
    }
}

