/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.MSSQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.SybaseASADatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;
import liquibase.util.StringUtils;

public class AddUniqueConstraintStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String columnNames;
    private String constraintName;
    private String tablespace;

    public AddUniqueConstraintStatement(String schemaName, String tableName, String columnNames, String constraintName) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.columnNames = columnNames;
        this.constraintName = constraintName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public AddUniqueConstraintStatement setTablespace(String tablespace) {
        this.tablespace = tablespace;
        return this;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        String sql = "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ADD CONSTRAINT " + database.escapeConstraintName(this.getConstraintName()) + " UNIQUE (" + database.escapeColumnNameList(this.getColumnNames()) + ")";
        if (StringUtils.trimToNull(this.getTablespace()) != null && database.supportsTablespaces()) {
            if (database instanceof MSSQLDatabase) {
                sql = sql + " ON " + this.getTablespace();
            } else if (!(database instanceof DB2Database) && !(database instanceof SybaseASADatabase)) {
                sql = sql + " USING INDEX TABLESPACE " + this.getTablespace();
            }
        }
        return sql;
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof SQLiteDatabase);
    }
}

