/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringUtils {
    public static String trimToEmpty(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.length() == 0) {
            return null;
        }
        return returnString;
    }

    public static String[] processMutliLineSQL(String multiLineSQL, boolean stripComments) {
        String stripped = stripComments ? StringUtils.stripComments(multiLineSQL) : multiLineSQL;
        return StringUtils.splitSQL(stripped);
    }

    public static String[] splitSQL(String multiLineSQL) {
        return multiLineSQL.split(";\\s*\n|;$|\n[gG][oO]\\s*\n|\n[Gg][oO]$");
    }

    public static String stripComments(String multiLineSQL) {
        String strippedSingleLines = multiLineSQL.replaceAll("\\s--\\s.*", "");
        return strippedSingleLines.replaceAll("/\\*[\n\\S\\s]*\\*/", "\n");
    }

    public static String join(Collection<String> collection, String delimiter) {
        if (collection == null) {
            return null;
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (String val : collection) {
            buffer.append(val).append(delimiter);
        }
        String returnString = buffer.toString();
        return returnString.substring(0, returnString.length() - delimiter.length());
    }

    public static List<String> splitAndTrim(String s, String regex) {
        if (s == null) {
            return null;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        for (String string : s.split(regex)) {
            returnList.add(string.trim());
        }
        return returnList;
    }
}

